/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.ProjectileSummonHelperEntity;
import io.github.flemmli97.runecraftory.common.particles.BlockStateParticleData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GroundShakeParticleSpawner
extends ProjectileSummonHelperEntity {
    private final HashSet<BlockPos> pos = new HashSet();
    private double arc;
    private double range;

    public GroundShakeParticleSpawner(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public GroundShakeParticleSpawner(Level level, LivingEntity caster, double arc, double range) {
        super((EntityType)RuneCraftoryEntities.GROUND_SHAKE_PARTICLES.get(), level, caster);
        this.setPos(caster.getX(), caster.getY(), caster.getZ());
        this.arc = arc;
        this.range = range;
    }

    @Override
    public int getMaxLivingTicks() {
        return 8;
    }

    @Override
    protected void summonProjectiles() {
        Vec3 dir = new Vec3(this.targetX - this.getX(), 0.0, this.targetZ - this.getZ()).normalize();
        float yRot = MathsHelper.YRotFrom(dir);
        double progress = (double)this.ticksExisted / (double)this.getMaxLivingTicks();
        double range = progress * this.range;
        int amount = Mth.ceil((double)(1.2 * this.arc * Math.ceil(range) / 90.0));
        for (int i = 0; i < amount; ++i) {
            float angle = yRot + (360.0f * ((float)i / (float)amount) - 0.5f);
            Vec3 target = dir.scale(range).yRot(angle * ((float)Math.PI / 180));
            target = this.position().add(target.x, -1.0, target.z);
            BlockPos pos = BlockPos.containing((Position)target);
            if (this.pos.contains(pos)) continue;
            this.pos.add(pos);
            BlockState state = this.level().getBlockState(pos);
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockStateParticleData((ParticleType<? extends BlockStateParticleData>)((ParticleType)RuneCraftoryParticles.BLOCK.get()), state, this.random.nextFloat() * 360.0f, this.random.nextFloat() * 10.0f, 30), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0, 0.0, this.random.nextDouble() * 0.05 + 0.15, 0.0, 1.0);
        }
    }
}

