/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.entities.misc.ElementalBallEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class GustRocksEntity
extends BaseBeam {
    private Vec3 up;
    private Vec3 side;

    public GustRocksEntity(EntityType<? extends GustRocksEntity> type, Level level) {
        super(type, level);
    }

    public GustRocksEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseBeam>)((EntityType)RuneCraftoryEntities.GUST_ROCK.get()), level, shooter);
        this.setPos(shooter.getX(), shooter.getY() + (double)shooter.getBbHeight() + 2.0, shooter.getZ());
    }

    public float getRange() {
        return 20.0f;
    }

    public float radius() {
        return 9.0f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return 30;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean canStartDamage() {
        return this.livingTicks > 4;
    }

    public void updateHitDetectBox() {
        this.hitObb = new OrientedBoundingBox(new AABB((double)(-this.radius()), (double)(-this.radius()) * 0.5, 0.0, (double)this.radius(), (double)this.radius(), (double)this.getRange()), this.getYRot(), -this.getXRot(), this.position());
    }

    public void tick() {
        super.tick();
        Vec3 dir = this.getLookAngle();
        if (this.up == null) {
            this.up = this.calculateViewVector(this.getXRot() - 90.0f, this.getYRot()).scale((double)this.radius());
            this.side = dir.cross(this.up).normalize().scale((double)this.radius());
        }
        Vec3 pos = this.position();
        if (this.level().isClientSide) {
            Vec3 look = dir.scale(6.0);
            for (int i = 0; i < 20; ++i) {
                double randX = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.radius() - look.x();
                double randY = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.radius() - look.y();
                double randZ = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.radius() - look.z();
                Vec3 pos2 = pos.add(randX, randY, randZ);
                AdvancedParticleContainer.make((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1)).addData((AdvancedParticleData)new MotionData(dir.x(), dir.y(), dir.z())).addData((AdvancedParticleData)new ScaleData(0.3f)).addData((AdvancedParticleData)new ParticleMetaData(30, false, 0.0f)).add(this.level(), pos2.x(), pos2.y(), pos2.z());
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                Entity randX = this.getOwner();
                if (!(randX instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)randX;
                ElementalBallEntity spellBall = new ElementalBallEntity(this.level(), living, ItemElement.EARTH);
                spellBall.withMaxLivingTicks(60);
                spellBall.setDamageMultiplier(this.damageMultiplier);
                double upScale = this.random.nextDouble() * 1.5 - 0.5;
                double sideScale = this.random.nextDouble() * 2.0 - 1.0;
                Vec3 pos2 = pos.add(dir.scale(-8.0)).add(this.up.scale(upScale)).add(this.side.scale(sideScale));
                spellBall.setPos(pos2.x(), pos2.y(), pos2.z());
                spellBall.shoot(dir.x(), dir.y(), dir.z(), 0.9f, 0.0f);
                this.level().addFreshEntity((Entity)spellBall);
            }
        }
    }

    public void onImpact(EntityHitResult result) {
        Vec3 mot = this.getLookAngle().scale(0.31);
        result.getEntity().push(mot.x(), mot.y(), mot.z());
        result.getEntity().hurtMarked = true;
    }
}

