/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MarionettaTrapEntity
extends Entity
implements OwnableEntity,
AnimatedEntity {
    public static int SWORDS = 7;
    public static int DURATION = 120;
    public static int SPIN_START = 80;
    public static int SPIN_STOP = 40;
    public static int[] ATTACK_TIMES = MarionettaTrapEntity.calculateAttackTimes();
    private static final EntityDataAccessor<CompoundTag> CAUGHT_ENTITIES = SynchedEntityData.defineId(MarionettaTrapEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final AnimationDefinitionContainer ANIMS = new AnimationDefinitionContainer(Map.of());
    private final List<LivingEntity> caughtEntities = new ArrayList<LivingEntity>();
    private final AnimationHandler<MarionettaTrapEntity> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private int tickLeft = DURATION;
    private LivingEntity shooter;
    private UUID shooterUUID;
    private float damageMultiplier = 0.7f;
    private final boolean[] playSpawnSound = new boolean[SWORDS];
    private int shakeTicks;

    public MarionettaTrapEntity(EntityType<? extends MarionettaTrapEntity> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public MarionettaTrapEntity(Level level, LivingEntity shooter) {
        this((EntityType<? extends MarionettaTrapEntity>)((EntityType)RuneCraftoryEntities.TRAP_CHEST.get()), level);
        this.shooter = shooter;
        this.shooterUUID = shooter.getUUID();
        this.setPos(shooter.getX(), shooter.getEyeY(), shooter.getZ());
    }

    public static double horizontalMag(Vec3 vec) {
        return vec.x * vec.x + vec.z * vec.z;
    }

    private static int[] calculateAttackTimes() {
        int[] times = new int[SWORDS];
        int time = 27;
        for (int i = 0; i < SWORDS; ++i) {
            times[i] = time;
            time -= 3;
        }
        return times;
    }

    public void addCaughtEntity(LivingEntity entity) {
        this.caughtEntities.add(entity);
        this.entityData.set(CAUGHT_ENTITIES, (Object)this.writeCaughtEntities());
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    public void throwIn(Vec3 dir) {
        this.setMotionWithRotation(dir);
    }

    private void setMotionWithRotation(Vec3 motion) {
        this.setDeltaMovement(motion);
        double f = Math.sqrt(MarionettaTrapEntity.horizontalMag(motion));
        this.setYRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)motion.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CAUGHT_ENTITIES, (Object)new CompoundTag());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == CAUGHT_ENTITIES) {
            CompoundTag tag = (CompoundTag)this.entityData.get(CAUGHT_ENTITIES);
            this.readCaughtEntities(tag);
        }
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void baseTick() {
        super.baseTick();
        if (!this.onGround()) {
            Vec3 motion = this.getDeltaMovement();
            double f = Math.sqrt(MarionettaTrapEntity.horizontalMag(motion));
            this.setYRot(this.updateRotation(this.yRotO, (float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.29577951308232)));
            this.setXRot(this.updateRotation(this.xRotO, (float)(Mth.atan2((double)motion.y, (double)f) * 57.2957763671875)));
            boolean water = this.isInWater();
            float friction = water ? 0.8f : 0.85f;
            this.setDeltaMovement(motion.scale((double)friction).subtract(0.0, (double)0.05f, 0.0));
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        --this.tickLeft;
        this.caughtEntities.forEach(entity -> {
            if (entity.isAlive()) {
                ((EntityData)RunecraftoryAttachments.ENTITY_DATA.get().get(entity)).setInvis(10);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.moveTo(this.getX(), this.getY() + (double)this.getBbHeight() + 0.05, this.getZ());
                } else {
                    entity.setPos(this.getX(), this.getY() + (double)this.getBbHeight() + 0.05, this.getZ());
                }
                EntityData data = (EntityData)RunecraftoryAttachments.ENTITY_DATA.get().get(entity);
                if (!data.thirdPersonView()) {
                    data.setThirdPersonView(true);
                }
            }
        });
        if (!this.level().isClientSide) {
            if (this.getOwner() != null && this.canAttack(0)) {
                boolean[] success = new boolean[]{false};
                this.caughtEntities.forEach(e -> {
                    if (CombatUtils.mobAttack(this.getOwner(), (Entity)e, new DynamicDamage.Builder(this, (Entity)this.getOwner()).hurtResistant(0), CombatUtils.getAttributeValue((Entity)this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier) && !success[0]) {
                        success[0] = true;
                    }
                });
                if (success[0]) {
                    this.playSound(SoundEvents.PLAYER_ATTACK_CRIT, 1.0f, 1.0f);
                }
            }
            if (this.tickLeft <= 0) {
                this.caughtEntities.forEach(entity -> {
                    ((EntityData)RunecraftoryAttachments.ENTITY_DATA.get().get(entity)).setInvis(0);
                    ((EntityData)RunecraftoryAttachments.ENTITY_DATA.get().get(entity)).setThirdPersonView(false);
                });
                this.discard();
            }
        } else {
            --this.shakeTicks;
            if (this.canAttack(1) && !this.caughtEntities.isEmpty()) {
                this.shakeTicks = 2;
            }
        }
    }

    protected boolean canAttack(int offset) {
        for (int i : ATTACK_TIMES) {
            if (this.tickLeft + offset != i) continue;
            return true;
        }
        return false;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.damageMultiplier = compound.getFloat("DamageMultiplier");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("DamageMultiplier", this.damageMultiplier);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public int getTickLeft() {
        return this.tickLeft;
    }

    public float getSpinProgress(float partialTicks) {
        int duration = SPIN_START - SPIN_STOP;
        return 1.0f - Mth.clamp((float)(((float)(this.getTickLeft() - SPIN_STOP) - partialTicks) / (float)duration), (float)0.0f, (float)1.0f);
    }

    public float getAttackProgress(int idx, float partialTicks) {
        int time = ATTACK_TIMES[idx] - 1;
        return 1.0f - Mth.clamp((float)(((float)(this.getTickLeft() - time) - partialTicks) / 6.0f), (float)0.0f, (float)1.0f);
    }

    public float shake(float partialTicks) {
        if (this.shakeTicks <= 0) {
            return 0.0f;
        }
        return (float)this.shakeTicks - partialTicks;
    }

    public void playSpawnSound(int idx) {
        if (idx < 0 || idx >= this.playSpawnSound.length) {
            return;
        }
        if (!this.playSpawnSound[idx]) {
            this.playSpawnSound[idx] = true;
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARROW_SHOOT, this.getSoundSource(), 1.0f, 1.0f, false);
            } else {
                this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f);
            }
        }
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)prev, (float)current);
    }

    public UUID getOwnerUUID() {
        return this.shooterUUID;
    }

    @Nullable
    public LivingEntity getOwner() {
        UUID uuid;
        if ((this.shooter == null || this.shooter.isRemoved()) && (uuid = this.getOwnerUUID()) != null) {
            this.shooter = (LivingEntity)EntityUtils.findFromUUID(LivingEntity.class, (Level)this.level(), (UUID)uuid);
        }
        return this.shooter;
    }

    private CompoundTag writeCaughtEntities() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        this.caughtEntities.forEach(e -> list.add((Object)IntTag.valueOf((int)e.getId())));
        tag.put("Caught", (Tag)list);
        return tag;
    }

    private void readCaughtEntities(CompoundTag tag) {
        ListTag list = tag.getList("Caught", 3);
        this.caughtEntities.clear();
        list.forEach(t -> {
            Entity e = this.level().getEntity(((IntTag)t).getAsInt());
            if (e instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)e;
                this.caughtEntities.add(entity);
            }
        });
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }
}

