/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class PoisonNeedleEntity
extends BaseProjectile {
    public PoisonNeedleEntity(EntityType<? extends PoisonNeedleEntity> type, Level level) {
        super(type, level);
    }

    public PoisonNeedleEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.POISON_NEEDLE.get()), level, shooter);
    }

    public int livingTickMax() {
        return 50;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).hurtResistant(5).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.POISON.asHolder(), 30.0).projectile(), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null)) {
            this.discard();
            return true;
        }
        return false;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.discard();
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }
}

