/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class PollenEntity
extends BaseDamageCloud {
    private static final List<Vector3f> POLLEN_BASE = MathUtils.rotatedVecs((Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (float)-180.0f, (float)135.0f, (float)45.0f);
    private static final List<Vector3f> POLLEN_IND = MathUtils.rotatedVecs((Vector3f)new Vector3f(0.04f, 0.07f, 0.0f), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (float)-180.0f, (float)160.0f, (float)20.0f);

    public PollenEntity(EntityType<? extends PollenEntity> type, Level level) {
        super(type, level);
    }

    public PollenEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.POLLEN.get()), level, shooter);
    }

    private double radiusSqWithOffset(double offset) {
        double r = Math.max(0.0, (double)this.getRadius() + offset);
        return r * r;
    }

    public float radiusIncrease() {
        return 0.5f;
    }

    public double maxRadius() {
        return 2.0;
    }

    public int livingTickMax() {
        return 7;
    }

    public boolean canStartDamage() {
        return this.livingTicks % 2 == 1;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.livingTicks == 1) {
            this.level().broadcastEntityEvent((Entity)this, (byte)64);
        }
    }

    @Override
    protected boolean canHit(LivingEntity e) {
        double offset;
        if (!super.canHit(e)) {
            return false;
        }
        double distSq = e.distanceToSqr((Entity)this);
        return distSq >= this.radiusSqWithOffset(-(offset = (double)e.getBbWidth() * 0.5 + 0.1)) && distSq <= this.radiusSqWithOffset(offset);
    }

    protected boolean damageEntity(LivingEntity e) {
        return CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)e, new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(5).element(ItemElement.EARTH), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    protected AABB damageBoundingBox() {
        return super.damageBoundingBox().inflate(0.0, 0.3, 0.0);
    }

    public void handleEntityEvent(byte id) {
        if (id == 64) {
            for (Vector3f base : POLLEN_BASE) {
                for (Vector3f dir : POLLEN_IND) {
                    for (int i = 0; i < 3; ++i) {
                        AdvancedParticleContainer.make((ParticleOptions)new DustParticleOptions(new Vector3f(0.039215688f, 0.5411765f, 0.047058824f), 1.0f)).addData((AdvancedParticleData)new ScaleData(0.25f)).addData((AdvancedParticleData)new MotionData((double)dir.x() + (double)base.x() * 0.07, (double)dir.y(), (double)dir.z() + (double)base.z() * 0.07)).addData((AdvancedParticleData)new ParticleMetaData(15, true, 0.2f)).add(this.level(), this.getX() + (double)base.x(), this.getY() + 0.1, this.getZ() + (double)base.z());
                    }
                }
            }
        } else {
            super.handleEntityEvent(id);
        }
    }
}

