/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SlashResidueEntity
extends BaseDamageCloud {
    private static final Vec3[] BASE = new Vec3[]{Vec3.ZERO, new Vec3(0.5, 0.0, 0.0), new Vec3(-0.5, 0.0, 0.0)};
    protected static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(SlashResidueEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private boolean dummy;

    public SlashResidueEntity(EntityType<? extends BaseDamageCloud> type, Level level) {
        super(type, level);
    }

    public SlashResidueEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.SLASH_RESIDUE.get()), level, shooter);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SIZE, (Object)Float.valueOf(1.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (SIZE.equals(key)) {
            this.refreshDimensions();
        }
    }

    public void setSize(float size) {
        this.entityData.set(SIZE, (Object)Float.valueOf(Math.max(0.2f, size)));
        this.reapplyPosition();
        this.refreshDimensions();
    }

    public void dummy() {
        this.dummy = true;
    }

    public EntityDimensions getDimensions(Pose pose) {
        return super.getDimensions(pose).scale(((Float)this.entityData.get(SIZE)).floatValue());
    }

    public int livingTickMax() {
        return 15;
    }

    public boolean canStartDamage() {
        return !this.dummy && this.livingTicks % 3 == 1;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            double height = this.getBoundingBox().getYsize();
            for (Vec3 vec3 : BASE) {
                vec3 = vec3.scale((double)((Float)this.entityData.get(SIZE)).floatValue()).yRot((float)(-Math.PI) / 180 * this.getYRot());
                for (double d = 0.0; d < height; d += 0.2) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, this.getX() + vec3.x, this.getY() + vec3.y + d, this.getZ() + vec3.z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected boolean damageEntity(LivingEntity target) {
        return CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)target, new DynamicDamage.Builder((Entity)this, this.getOwner()).noKnockback().hurtResistant(2), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(SIZE, (Object)Float.valueOf(compound.getFloat("Size")));
        this.dummy = compound.getBoolean("Dummy");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Size", ((Float)this.entityData.get(SIZE)).floatValue());
        compound.putBoolean("Dummy", this.dummy);
    }

    public static enum Type {
        CHIMERA,
        SKELEFANG;

    }
}

