/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;

public class SleepAuraEntity
extends BaseDamageCloud {
    private final Set<UUID> hitEntities = new HashSet<UUID>();

    public SleepAuraEntity(EntityType<? extends SleepAuraEntity> type, Level level) {
        super(type, level);
    }

    public SleepAuraEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.SLEEP_AURA.get()), level, shooter);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            for (int i = 0; i < 12; ++i) {
                double x = this.getRandomX(0.9);
                double y = this.getRandomY();
                double z = this.getRandomZ(0.9);
                this.level().addAlwaysVisibleParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.6313726f, (float)0.7882353f, (float)0.7647059f), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected boolean canHit(LivingEntity e) {
        return super.canHit(e) && !this.hitEntities.contains(e.getUUID());
    }

    protected boolean damageEntity(LivingEntity target) {
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)target, new DynamicDamage.Builder((Entity)this, this.getOwner()).hurtResistant(4).magic().element(ItemElement.EARTH).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.SLEEP.asHolder(), 100.0), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            this.hitEntities.add(target.getUUID());
            return true;
        }
        return false;
    }
}

