/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class StarfallEntity
extends BaseProjectile {
    public StarfallEntity(EntityType<? extends StarfallEntity> type, Level level) {
        super(type, level);
    }

    public StarfallEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.STARFALL.get()), level, shooter);
    }

    public int livingTickMax() {
        return 60;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
        if (this.level().isClientSide) {
            for (int i = 0; i < 2; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.19215687f, 0.40392157f, 0.7411765f, 0.8f)).addData((AdvancedParticleData)new ScaleData(0.25f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, Math.abs(this.random.nextGaussian() * 0.03), this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, true, 0.2f)).add(this.level(), this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0));
            }
        }
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).element(ItemElement.LIGHT).noKnockback().hurtResistant(10), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            this.discard();
            return true;
        }
        return false;
    }

    protected EntityHitResult getEntityHit(Vec3 from, Vec3 to) {
        if (!this.isAlive()) {
            return null;
        }
        return StarfallEntity.getEntityHitResult(this, to, this::canHit);
    }

    private static EntityHitResult getEntityHitResult(AdvancedProjectile projectile, Vec3 to, Predicate<Entity> pred) {
        double dY = to.y() - projectile.getY();
        AABB bb = projectile.getBoundingBox().expandTowards(0.0, dY, 0.0);
        for (Entity e : projectile.level().getEntities((Entity)projectile, bb.inflate(1.0), pred)) {
            if (!e.getBoundingBox().inflate(0.3).intersects(bb)) continue;
            return new EntityHitResult(e);
        }
        return null;
    }

    protected void onBlockHit(BlockHitResult blockHitResult) {
    }
}

