/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ThrownItemEntity
extends BaseProjectile {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(ThrownItemEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> ROTATING = SynchedEntityData.defineId(ThrownItemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean actAsFood;

    public ThrownItemEntity(EntityType<? extends ThrownItemEntity> type, Level level) {
        super(type, level);
    }

    public ThrownItemEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.THROWN_ITEM.get()), level, shooter);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STACK, (Object)ItemStack.EMPTY);
        builder.define(ROTATING, (Object)false);
    }

    public int livingTickMax() {
        return 30;
    }

    public void setItem(ItemStack stack) {
        this.entityData.set(STACK, (Object)((ItemStack)Util.make((Object)stack.copy(), itemStack -> itemStack.setCount(1))));
    }

    public void setActAsFood(boolean flag) {
        this.actAsFood = flag;
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(STACK);
    }

    public void setRotating(boolean rotating) {
        this.entityData.set(ROTATING, (Object)rotating);
    }

    public boolean isRotating() {
        return (Boolean)this.entityData.get(ROTATING);
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (this.actAsFood) {
            ItemStack stack = this.getItem();
            Entity entity = result.getEntity();
            if (entity instanceof IBaseMob) {
                IBaseMob mob = (IBaseMob)entity;
                e = this.getOwner();
                if (e instanceof Player) {
                    Player thrower = (Player)e;
                    if (mob.onGivingItem(thrower, stack) && stack.isEmpty()) {
                        this.discard();
                    }
                } else {
                    mob.applyFoodEffect(stack);
                }
            } else {
                e = result.getEntity();
                if (e instanceof Player) {
                    Player player = (Player)e;
                    e = this.getOwner();
                    if (!(e instanceof Player)) {
                        player.eat(player.level(), stack);
                        if (stack.isEmpty()) {
                            this.discard();
                        }
                    } else {
                        ItemEntity entity2 = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem());
                        this.level().addFreshEntity((Entity)entity2);
                    }
                }
            }
            return true;
        }
        boolean res = CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).hurtResistant(3).projectile(), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null);
        if (res) {
            this.discard();
        }
        return res;
    }

    protected void onBlockHit(BlockHitResult result) {
        if (this.actAsFood) {
            ItemEntity entity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem());
            this.level().addFreshEntity((Entity)entity);
        }
        this.discard();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ItemStack itemStack = this.getItem();
        if (!itemStack.isEmpty()) {
            compound.put("Item", itemStack.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
        compound.putBoolean("Rotating", this.isRotating());
        compound.putBoolean("ActAsFood", this.actAsFood);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound("Item"));
        this.setItem(itemStack);
        this.setRotating(compound.getBoolean("Rotating"));
        this.actAsFood = compound.getBoolean("ActAsFood");
    }
}

