/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.entities.misc.WindBladeEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.CirclingData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TornadoEntity
extends BaseDamageCloud {
    public TornadoEntity(EntityType<? extends TornadoEntity> type, Level level) {
        super(type, level);
    }

    public TornadoEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.TORNADO.get()), level, shooter);
    }

    public int livingTickMax() {
        return 100;
    }

    public boolean canStartDamage() {
        return this.livingTicks > 3;
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vector3d);
        double f = Math.sqrt(AdvancedProjectile.horizontalMag((Vec3)vector3d));
        this.setYRot((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void tick() {
        block2: {
            block1: {
                super.tick();
                if (this.level().isClientSide) break block1;
                Entity entity = this.getOwner();
                if (!(entity instanceof LivingEntity)) break block2;
                LivingEntity living = (LivingEntity)entity;
                if (!this.random.nextBoolean()) break block2;
                WindBladeEntity wind = new WindBladeEntity(this.level(), living);
                wind.setPos(this.getX(), this.getRandomY(), this.getZ());
                wind.setDamageMultiplier(this.damageMultiplier);
                wind.setType(WindBladeEntity.Type.PLAIN);
                wind.shoot(this.random.nextDouble() - 0.5, this.random.nextDouble() * 0.3 - 0.15, this.random.nextDouble() - 0.5, 0.6f, 3.0f);
                this.level().addFreshEntity((Entity)wind);
                break block2;
            }
            for (int i = 0; i < 8; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)((float)(49 + this.random.nextInt(25)) / 255.0f), (float)((float)(150 + this.random.nextInt(40)) / 255.0f), (float)((float)(18 + this.random.nextInt(25)) / 255.0f))).addData((AdvancedParticleData)new ScaleData(0.17f + this.getRandom().nextFloat() * 0.05f)).addData((AdvancedParticleData)new MotionData(this.getDeltaMovement().x(), 0.35, this.getDeltaMovement().z())).addData((AdvancedParticleData)new CirclingData(0.0f, 0.07f, (float)this.random.nextInt(360), (float)(10 + this.getRandom().nextInt(5)), MathUtils.NORMAL_Y)).addData((AdvancedParticleData)new ParticleMetaData(17 + this.getRandom().nextInt(8), false, 0.0f)).add(this.level(), this.getRandomX(0.15), this.getY(), this.getRandomZ(0.15));
            }
        }
        Vec3 motion = this.getDeltaMovement();
        double newX = this.getX() + motion.x;
        double newY = this.getY() + motion.y;
        double newZ = this.getZ() + motion.z;
        this.setPos(newX, newY, newZ);
        this.setDeltaMovement(motion.scale(0.99));
    }

    protected boolean damageEntity(LivingEntity livingEntity) {
        return CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)livingEntity, new DynamicDamage.Builder((Entity)this, this.getOwner()).element(ItemElement.WIND).magic().noKnockback().hurtResistant(10), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    protected AABB damageBoundingBox() {
        return super.damageBoundingBox().inflate(0.2, 0.5, 0.2);
    }
}

