/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.loader.TenshiLibCrossPlat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WindBladeEntity
extends BaseProjectile {
    private Entity target;
    private Type type = Type.HOMING;
    private int livingTickMax = 70;

    public WindBladeEntity(EntityType<? extends WindBladeEntity> type, Level level) {
        super(type, level);
    }

    public WindBladeEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.WIND_BLADE.get()), level, shooter);
    }

    public void setTarget(Entity entity) {
        this.target = entity;
    }

    public void setType(Type type) {
        this.type = type;
        this.livingTickMax = this.isPiercing() ? 70 : 40;
    }

    public void maxTicks(int maxTicks) {
        this.livingTickMax = maxTicks;
    }

    public boolean isPiercing() {
        return this.type == Type.PIERCING;
    }

    public int livingTickMax() {
        return this.livingTickMax;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (!(this.target != null && this.target.isAlive() || this.type != Type.HOMING)) {
                List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(16.0).expandTowards(this.getDeltaMovement()), e -> {
                    OwnableEntity ownable;
                    if (!e.isPickable() || !e.isAttackable()) {
                        return false;
                    }
                    if (e.equals((Object)this.getOwner()) || e instanceof OwnableEntity && (ownable = (OwnableEntity)e).getOwner() == this.getOwner()) {
                        return false;
                    }
                    return this.canHit((Entity)e);
                });
                double distSq = Double.MAX_VALUE;
                Entity res = null;
                for (Entity e2 : list) {
                    if (!(e2.distanceToSqr((Entity)this) < distSq)) continue;
                    res = e2;
                }
                if (res != null) {
                    this.target = res;
                }
            }
            if (this.target != null) {
                Vec3 dir = this.target.getEyePosition().subtract(this.position()).normalize().scale(0.1);
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(dir));
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(this.type == Type.PLAIN ? 4 : 10).element(ItemElement.WIND).projectile(), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            if (!this.isPiercing()) {
                this.discard();
            }
            return true;
        }
        return false;
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        if (!this.isPiercing()) {
            this.discard();
        } else {
            Vec3 mot = this.getDeltaMovement();
            Vec3 newMot = switch (blockRayTraceResult.getDirection()) {
                case Direction.DOWN, Direction.UP -> new Vec3(mot.x(), -mot.y(), mot.z());
                case Direction.WEST, Direction.EAST -> new Vec3(-mot.x(), mot.y(), mot.z());
                default -> new Vec3(mot.x(), mot.y(), -mot.z());
            };
            if (!blockRayTraceResult.isInside()) {
                this.setPos(blockRayTraceResult.getLocation());
            }
            this.setDeltaMovement(newMot);
            this.doBlockCollision();
        }
    }

    private void doBlockCollision() {
        Vec3 pos = this.position();
        Vec3 to = pos.add(this.getDeltaMovement());
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(pos, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.getType() == HitResult.Type.BLOCK && !TenshiLibCrossPlat.INSTANCE.projectileImpactEvent((Projectile)this, (HitResult)raytraceresult)) {
            BlockPos blockpos = raytraceresult.getBlockPos();
            BlockState blockstate = this.level().getBlockState(blockpos);
            blockstate.onProjectileHit(this.level(), blockstate, raytraceresult, (Projectile)this);
            this.onBlockHit(raytraceresult);
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setType(Type.values()[compound.getInt("Type")]);
        this.maxTicks(compound.getInt("MaxTicks"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Type", this.type.ordinal());
        compound.putInt("MaxTicks", this.livingTickMax());
    }

    public static enum Type {
        PLAIN,
        HOMING,
        PIERCING;

    }
}

