/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.tenshilib.common.entity.BeamEntity;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import java.util.function.Predicate;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WindGustEntity
extends BeamEntity {
    private Vec3 pMotion;
    private Vec3 up;
    private Vec3 side;
    private Predicate<LivingEntity> pred = e -> !e.equals((Object)this.getOwner());

    public WindGustEntity(EntityType<? extends WindGustEntity> type, Level level) {
        super(type, level);
    }

    public WindGustEntity(Level level, LivingEntity shooter) {
        super((EntityType)RuneCraftoryEntities.GUST.get(), level, shooter);
        if (shooter instanceof BaseMonster) {
            this.pred = e -> ((BaseMonster)shooter).hitPred.test((LivingEntity)e);
        }
    }

    public float getRange() {
        return 8.0f;
    }

    public float radius() {
        return 3.0f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return 15;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void updateHitDetectBox() {
        super.updateHitDetectBox();
        if (!this.level().isClientSide) {
            S2CAttackDebug.sendDebugPacket(this.hitObb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            Vec3 pos = this.position();
            for (int i = 0; i < 4; ++i) {
                double upScale = this.random.nextDouble() * 2.0 - 1.0;
                double sideScale = this.random.nextDouble() * 2.0 - 1.0;
                Vec3 ppos = pos.add(this.up.scale(upScale)).add(this.side.scale(sideScale));
                AdvancedParticleContainer.make((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1)).addData((AdvancedParticleData)new MotionData(this.pMotion.x(), this.pMotion.y(), this.pMotion.z())).addData((AdvancedParticleData)new ScaleData(0.2f)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), ppos.x(), ppos.y(), ppos.z());
            }
        }
    }

    public HitResult getHitRay() {
        HitResult res = super.getHitRay();
        Vec3 dir = res.getLocation().subtract(this.getEyePosition()).normalize();
        this.up = this.calculateViewVector(this.getXRot() - 90.0f, this.getYRot()).scale((double)this.radius());
        this.side = dir.cross(this.up).normalize().scale((double)this.radius());
        this.pMotion = dir.scale(0.3);
        return res;
    }

    protected boolean check(Entity e, Predicate<AABB> intersects) {
        LivingEntity living;
        return super.check(e, intersects) && (!(e instanceof LivingEntity) || this.pred.test(living = (LivingEntity)e));
    }

    public void onImpact(EntityHitResult entityRayTraceResult) {
        Entity e = entityRayTraceResult.getEntity();
        if (e instanceof LivingEntity) {
            Vec3 mot = this.hit.getLocation().subtract(this.position()).normalize().scale(0.3);
            e.push(mot.x(), mot.y(), mot.z());
            e.hurtMarked = true;
        }
    }

    public boolean canStartDamage() {
        return true;
    }

    public Entity getOwner() {
        Entity owner = super.getOwner();
        if (owner instanceof BaseMonster) {
            this.pred = ((BaseMonster)owner).hitPred;
        }
        return owner;
    }
}

