/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc.summoners;

import io.github.flemmli97.runecraftory.common.entities.misc.ProjectileSummonHelperEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BlazeBarrageSummoner
extends ProjectileSummonHelperEntity {
    public BlazeBarrageSummoner(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public BlazeBarrageSummoner(Level level, LivingEntity caster) {
        super((EntityType)RuneCraftoryEntities.BLAZE_BARRAGE.get(), level, caster);
        this.maxLivingTicks = 15;
    }

    @Override
    protected void summonProjectiles() {
        if (this.ticksExisted % 5 == 0) {
            Mob mob;
            LivingEntity owner = this.getOwner();
            if (owner == null) {
                return;
            }
            Vec3 look = owner instanceof Mob && (mob = (Mob)owner).getTarget() != null ? new Vec3(mob.getTarget().getX() - owner.getX(), mob.getTarget().getY() - owner.getY(), mob.getTarget().getZ() - owner.getZ()).normalize() : owner.getViewVector(1.0f);
            float inaccuracy = 5.0f;
            Vec3 vec3 = look.normalize().add(this.random.nextGaussian() * 0.0075 * (double)inaccuracy, this.random.nextGaussian() * 0.0075 * (double)inaccuracy, this.random.nextGaussian() * 0.0075 * (double)inaccuracy).scale(2.0);
            SmallFireball fireball = new SmallFireball(this.level(), owner, vec3);
            fireball.setPos(fireball.getX(), owner.getY(0.5) + 0.5, fireball.getZ());
            this.playSound(SoundEvents.BLAZE_SHOOT, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.level().addFreshEntity((Entity)fireball);
        }
    }
}

