/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc.summoners;

import io.github.flemmli97.runecraftory.common.entities.misc.ElementalTrailEntity;
import io.github.flemmli97.runecraftory.common.entities.misc.ProjectileSummonHelperEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireWallSummoner
extends ProjectileSummonHelperEntity {
    public FireWallSummoner(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public FireWallSummoner(Level level, LivingEntity caster) {
        super((EntityType)RuneCraftoryEntities.FIRE_WALL_SUMMONER.get(), level, caster);
        this.maxLivingTicks = 35;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.ticksExisted == 5) {
            Vec3 dir = new Vec3(this.targetX, this.targetY, this.targetZ).subtract(this.position()).normalize().scale(1.8);
            AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(1.0f, 1.0f, 1.0f, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.5f)).addData((AdvancedParticleData)new MotionData(dir.x(), dir.y(), dir.z())).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getX(), this.getY(), this.getZ());
        }
    }

    @Override
    protected void summonProjectiles() {
        LivingEntity owner = this.getOwner();
        if (this.ticksExisted > 10 && this.ticksExisted % 2 == 0) {
            Vec3 dir = new Vec3(this.targetX, this.targetY, this.targetZ).subtract(this.position()).normalize();
            ElementalTrailEntity fire = new ElementalTrailEntity(this.level(), owner, ItemElement.FIRE);
            fire.setPos(this.position().add(dir.scale((double)((float)(this.ticksExisted - 10) / 2.0f * 1.0f))));
            this.playSound((SoundEvent)RuneCraftorySounds.ENTITY_FIREWALL_SPAWN.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.level().addFreshEntity((Entity)fire);
        }
    }
}

