/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.SporeCircleSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class BigMuck
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SLAP = BUILDER.add("slap", AnimationsBuilder.definition((double)1.2).marker("attack", new double[]{0.36}));
    public static final String INTERACT = BUILDER.add("interact", SLAP);
    public static final String SPORE = BUILDER.add("spore", AnimationsBuilder.definition((double)2.16).marker("attack", new double[]{0.96}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<BigMuck> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public BigMuck(EntityType<? extends BigMuck> type, Level level) {
        super(type, level);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SLAP}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(2).start(new String[]{SPORE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(3, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(1, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{SPORE})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.getYRot(), 0.0f, this.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        if (anim.is(new String[]{SPORE})) {
            double attackSize = (double)this.getBbWidth() * 1.5;
            return new AABB(-attackSize, -0.2, -attackSize, attackSize, (double)this.getBbHeight() + 0.2, attackSize);
        }
        double width = (double)this.getBbWidth() * 1.4;
        double length = this.getBbWidth() * 2.0f;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{SPORE})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((SporeCircleSpell)RuneCraftorySpells.SPORE_CIRCLE_SPELL.get()).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<BigMuck> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 1 ? (Spell)RuneCraftorySpells.SPORE_CIRCLE_SPELL.get() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(SPORE);
            } else {
                this.getAnimationHandler().setAnimation(SLAP);
            }
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

