/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Cluckadoodle
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE = BUILDER.add("attack", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.52}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Cluckadoodle> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public Cluckadoodle(EntityType<? extends Cluckadoodle> type, Level level) {
        super(type, level);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.27);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(3, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(1, new ExtendedBehaviour[]{new StrafeTarget()}).build();
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.4;
        double length = (double)this.getBbWidth() * 2.2;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public int animationCooldown(String anim) {
        return Math.max(25, (int)((double)super.animationCooldown(anim) * 0.7));
    }

    public AnimationHandler<Cluckadoodle> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                return;
            }
            this.getAnimationHandler().setAnimation(MELEE);
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)RuneCraftorySounds.ENTITY_CLUCKADOODLE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)RuneCraftorySounds.ENTITY_CLUCKADOODLE_DEATH.get();
    }

    public float getVoicePitch() {
        return 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

