/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.ElementalAttackMob;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.DarkBallSpell;
import io.github.flemmli97.runecraftory.common.spells.HealT2Spell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Demon
extends BaseMonster
implements HealingPredicateEntity,
ElementalAttackMob {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String DARK = BUILDER.add("cast", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.52}));
    public static final String HEAL = BUILDER.add("heal", DARK);
    public static final String INTERACT = BUILDER.add("interact", DARK);
    public static final String STAB = BUILDER.add("stab", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.4}));
    public static final String STAB_LONG = BUILDER.add("stab_long", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.48}));
    public static final String SWIPE = BUILDER.add("swipe", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.44}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Demon> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private final Predicate<LivingEntity> healingPredicate = e -> {
        if (this.getOwnerUUID() == null) {
            OwnableEntity ownable;
            if (e instanceof OwnableEntity && (ownable = (OwnableEntity)e).getOwnerUUID() != null) {
                return false;
            }
            return e instanceof Enemy && e != this.getTarget();
        }
        if (e instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)e;
            if (this.getOwnerUUID().equals(ownable.getOwnerUUID())) {
                return true;
            }
        }
        return this.getOwnerUUID().equals(e.getUUID());
    };

    public Demon(EntityType<? extends Demon> type, Level level) {
        super(type, level);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{STAB}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{STAB_LONG}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{SWIPE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{DARK}).play(MonsterBehaviourUtils.cooldownedPlay()).end(3).start(new String[]{DARK}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifFurtherThan(4.0)).end(5).start(new String[]{HEAL}).play(MonsterBehaviourUtils.cooldownedPlay()).end(2).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(12.0f)}).add(3, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width;
        double length = width = (double)(this.getBbWidth() * 1.0f);
        if (anim.is(new String[]{STAB})) {
            width = (double)this.getBbWidth() * 1.8;
            length = (double)this.getBbWidth() * 4.5;
        } else if (anim.is(new String[]{STAB_LONG})) {
            width = (double)this.getBbWidth() * 1.8;
            length = (double)this.getBbWidth() * 5.5;
        } else if (anim.is(new String[]{SWIPE})) {
            width = (double)this.getBbWidth() * 4.35;
            length = (double)this.getBbWidth() * 3.6;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{DARK})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((DarkBallSpell)RuneCraftorySpells.DARK_BALL.get()).use((LivingEntity)this);
            }
        } else if (anim.is(new String[]{HEAL})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((HealT2Spell)RuneCraftorySpells.CURE_ALL.get()).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<Demon> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 2 ? (Spell)RuneCraftorySpells.DARK_BALL.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(DARK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(SWIPE);
            } else {
                this.getAnimationHandler().setAnimation(STAB);
            }
        }
    }

    @Override
    public ItemElement getAttackElement() {
        return ItemElement.DARK;
    }

    @Override
    public Predicate<LivingEntity> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

