/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.HealT2Spell;
import io.github.flemmli97.runecraftory.common.spells.ShineSpell;
import io.github.flemmli97.runecraftory.common.spells.WindBladeSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.jetbrains.annotations.Nullable;

public class Fairy
extends BaseMonster
implements HealingPredicateEntity {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String LIGHT = BUILDER.add("light", AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.32}));
    public static final String HEAL = BUILDER.add("heal", LIGHT);
    public static final String INTERACT = BUILDER.add("interact", LIGHT);
    public static final String WIND = BUILDER.add("wind", AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.48}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Fairy> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private final Predicate<LivingEntity> healingPredicate = e -> {
        if (this.getOwnerUUID() == null) {
            OwnableEntity ownable;
            if (e instanceof OwnableEntity && (ownable = (OwnableEntity)e).getOwnerUUID() != null) {
                return false;
            }
            return e instanceof Enemy && e != this.getTarget();
        }
        if (e instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)e;
            if (this.getOwnerUUID().equals(ownable.getOwnerUUID())) {
                return true;
            }
        }
        return this.getOwnerUUID().equals(e.getUUID());
    };

    public Fairy(EntityType<? extends Fairy> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
        this.moveControl = new FreeMoveControl((Mob)this);
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(32.0);
        this.getAttribute(Attributes.FLYING_SPEED).setBaseValue(0.3);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{WIND}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(15.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(new String[]{LIGHT}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(15))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveTo()}).end(3).start(new String[]{HEAL}).play(MonsterBehaviourUtils.cooldownedPlay()).end(2).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(12)), MonsterBehaviourUtils.moveTo()}).add(5, MonsterBehaviourUtils.ifCloserThan(12.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.getRandom().nextInt(20) + 30 + diffAdd;
        }
        return this.getRandom().nextInt(40) + 22 + diffAdd;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{LIGHT})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((ShineSpell)RuneCraftorySpells.SHINE.get()).use((LivingEntity)this);
            }
        } else if (anim.is(new String[]{WIND})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((WindBladeSpell)RuneCraftorySpells.DOUBLE_SONIC.get()).use((LivingEntity)this);
            }
        } else if (anim.is(new String[]{HEAL})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((HealT2Spell)RuneCraftorySpells.CURE_ALL.get()).use((LivingEntity)this);
            }
        }
    }

    public AnimationHandler<Fairy> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 1 ? (Spell)RuneCraftorySpells.SHINE.get() : (Spell)RuneCraftorySpells.DOUBLE_BULLET.get())) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LIGHT);
            } else {
                this.getAnimationHandler().setAnimation(WIND);
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)RuneCraftorySounds.ENTITY_FAIRY_AMBIENT.get();
    }

    @Override
    public Predicate<LivingEntity> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

