/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import org.jetbrains.annotations.Nullable;

public class FlowerLily
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)0.88).marker("leap", new double[]{0.28}));
    public static final String ATTACK = BUILDER.add("attack", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.32}));
    public static final String INTERACT = BUILDER.add("interact", ATTACK);
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public static final TypedResource<Vec3> LEAP_MOTION = new TypedResource(RuneCraftory.modRes("leap_motion"));
    private final AnimationHandler<FlowerLily> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.level().isClientSide) {
            this.setLeapMotion(null);
        }
        return false;
    });

    public FlowerLily(EntityType<? extends FlowerLily> type, Level level) {
        super(type, level);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.25);
        super.applyAttributes();
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(LEAP_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(15.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(2).start(new String[]{LEAP}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(3.0)).end(5).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(15.0f)}).add(2, MonsterBehaviourUtils.ifCloserThan(12.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{LEAP})) {
            return this.getLeapMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double attackSize = (double)this.getBbWidth() * 2.1;
        return new AABB(-attackSize, -0.2, -attackSize, attackSize, (double)this.getBbHeight() + 0.2, attackSize);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{LEAP})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.getYRot(), 0.0f, this.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.getRandom().nextInt(20) + 30 + diffAdd;
        }
        return this.getRandom().nextInt(40) + 25 + diffAdd;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{LEAP})) {
            this.getNavigation().stop();
            if (anim.isAt("leap")) {
                Vec3 vec32 = EntityUtils.getTargetDirection((Mob)this, EntityAnchorArgument.Anchor.FEET, true).scale(-2.0);
                this.setDeltaMovement(vec32.x, 0.15, vec32.z);
                this.setLeapMotion(this.getDeltaMovement());
            }
        } else if (anim.is(new String[]{ATTACK})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                this.rangedAttackSpell().use((LivingEntity)this);
            }
        }
    }

    public AnimationHandler<FlowerLily> getAnimationHandler() {
        return this.animationHandler;
    }

    public Vec3 getLeapMotion() {
        return (Vec3)this.getDataContainer().get(LEAP_MOTION);
    }

    public void setLeapMotion(Vec3 chargeMotion) {
        this.getDataContainer().set(LEAP_MOTION, (Object)chargeMotion);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 0 ? this.rangedAttackSpell() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    protected Spell rangedAttackSpell() {
        return (Spell)RuneCraftorySpells.DOUBLE_BULLET.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)RuneCraftorySounds.ENTITY_FLOWER_LILY_STEP.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

