/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.lib.LootTableResources;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.jetbrains.annotations.Nullable;

public class Wooly
extends LeapingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SLAP = BUILDER.add("slap", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.28, 0.56}));
    public static final String KICK = BUILDER.add("kick", AnimationsBuilder.definition((double)1.0).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{0.92}));
    public static final String HEADBUTT = BUILDER.add("headbutt", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.44}));
    public static final String INTERACT = BUILDER.add("interact", HEADBUTT);
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    protected static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.defineId(Wooly.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> SPAWNSHEARED = SynchedEntityData.defineId(Wooly.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimationHandler<Wooly> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public Wooly(EntityType<? extends Wooly> type, Level level) {
        super((EntityType<? extends LeapingMonster>)type, level);
        boolean sheared = (double)this.getRandom().nextFloat() < 0.05;
        this.entityData.set(SPAWNSHEARED, (Object)sheared);
        this.entityData.set(SHEARED, (Object)sheared);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.22);
        super.applyAttributes();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPAWNSHEARED, (Object)false);
        builder.define(SHEARED, (Object)false);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SLAP}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(new String[]{HEADBUTT}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(new String[]{KICK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepareOptional(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(3)), MonsterBehaviourUtils.moveTo()}).end(1).start(new String[]{KICK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepareOptional(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(5.0, 4.0), MonsterBehaviourUtils.moveTo()}).end(1).build().startCondition(MonsterBehaviourUtils.chancedStart(this::attackChance));
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(5, MonsterBehaviourUtils.ifCloserThan(5.0), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Sheared", this.isSheared());
        compound.putBoolean("SpawnedSheared", ((Boolean)this.entityData.get(SPAWNSHEARED)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSheared(compound.getBoolean("Sheared"));
        this.entityData.set(SPAWNSHEARED, (Object)compound.getBoolean("SpawnedSheared"));
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(RunecraftoryTags.Items.SHEARS)) {
            if (!(this.level().isClientSide || this.isSheared() || this.isTamed() && !player.getUUID().equals(this.getOwnerUUID()))) {
                this.shear(player, itemStack);
                itemStack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.getRandom().nextInt(20) + 30 + diffAdd;
        }
        return this.getRandom().nextInt(30) + 30 + diffAdd;
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.4;
        double length = (double)this.getBbWidth() * 1.9;
        if (anim.is(new String[]{HEADBUTT}) || anim.is(new String[]{KICK})) {
            length *= 1.5;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, this.vehicleDependentHeight() + 0.02, length);
    }

    public AnimationHandler<Wooly> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isLeapingAnim(String anim) {
        return anim.equals(KICK);
    }

    @Override
    public Vec3 getLeapVec(@Nullable Vec3 target) {
        return super.getLeapVec(target).scale(1.2);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(KICK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(HEADBUTT);
            } else {
                this.getAnimationHandler().setAnimation(SLAP);
            }
        }
    }

    @Override
    protected void tameEntity(Player owner) {
        super.tameEntity(owner);
        this.entityData.set(SPAWNSHEARED, (Object)false);
    }

    protected float attackChance() {
        return (Boolean)this.getEntityData().get(SPAWNSHEARED) != false || this.isTamed() ? 0.8f : 0.0f;
    }

    public void shear(Player player, ItemStack used) {
        LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(Wooly.shearedLootTable(this.getDefaultLootTable()));
        lootTable.getRandomItems(this.dailyDropContext().withOptionalParameter(LootCtxParameters.UUID_CONTEXT, (Object)player.getUUID()).withOptionalParameter(LootContextParams.TOOL, (Object)used).create(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((Wooly)this).spawnAtLocation(arg_0));
        this.setSheared(true);
        this.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
        this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
    }

    public static ResourceKey<LootTable> shearedLootTable(ResourceKey<LootTable> def) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)def.location().getNamespace(), (String)(def.location().getPath() + "_sheared_drops")));
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        if (this.isSheared()) {
            return super.getDefaultLootTable();
        }
        return LootTableResources.WOOLY_WHITE;
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(SHEARED);
    }

    public void setSheared(boolean flag) {
        this.entityData.set(SHEARED, (Object)flag);
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.SHEEP_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SHEEP_DEATH;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.7f;
    }

    @Override
    public void onDailyUpdate(int daysPassed) {
        super.onDailyUpdate(daysPassed);
        if (!((Boolean)this.entityData.get(SPAWNSHEARED)).booleanValue() || this.isTamed()) {
            this.setSheared(false);
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

