/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.AppleRain;
import io.github.flemmli97.runecraftory.common.spells.AppleShield;
import io.github.flemmli97.runecraftory.common.spells.HealT1Spell;
import io.github.flemmli97.runecraftory.common.spells.RootSpikeTriple;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import org.jetbrains.annotations.Nullable;

public class DeadTree
extends BossMonster {
    private static final EntityDataAccessor<Byte> SUMMON_ANIMATION = SynchedEntityData.defineId(DeadTree.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String ATTACK = BUILDER.add("attack", AnimationsBuilder.definition((double)1.16).marker("attack", new double[]{0.72, 0.92}));
    public static final String INTERACT = BUILDER.add("interact", ATTACK);
    public static final String FALLING_APPLES = BUILDER.add("falling_apples", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.6}).animationId("summon"));
    public static final String APPLE_SHIELD = BUILDER.add("apple_shield", FALLING_APPLES);
    public static final String SPIKE = BUILDER.add("spike", FALLING_APPLES);
    public static final String BIG_FALLING_APPLES = BUILDER.add("big_falling_apples", FALLING_APPLES);
    public static final String MORE_FALLING_APPLES = BUILDER.add("more_falling_apples", FALLING_APPLES);
    public static final String HEAL = BUILDER.add("heal", FALLING_APPLES);
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.68}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.68}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, DeadTree>> ATTACK_HANDLER = DeadTree.createAnimationHandler(b -> {
        b.put((Object)ATTACK, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, entity.getTarget(), entity::doHurtTarget);
            }
        });
        b.put((Object)FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((AppleRain)RuneCraftorySpells.APPLE_RAIN.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)APPLE_SHIELD, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((AppleShield)RuneCraftorySpells.APPLE_SHIELD.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)BIG_FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((AppleRain)RuneCraftorySpells.APPLE_RAIN_BIG.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)MORE_FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((AppleRain)RuneCraftorySpells.APPLE_RAIN_MORE.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)SPIKE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((RootSpikeTriple)RuneCraftorySpells.ROOT_SPIKE_TRIPLE.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)HEAL, (anim, entity) -> {
            if (anim.isAt("attack")) {
                float healAmount = entity.getMaxHealth() * (entity.getRandom().nextFloat() * 0.1f + 0.1f);
                entity.heal(healAmount);
                ServerLevel serverLevel = (ServerLevel)entity.level();
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, entity.getX(), entity.getY() + (double)entity.getBbHeight() + 0.5, entity.getZ(), 0, 0.0, 0.1, 0.0, 0.0);
                HealT1Spell.spawnHealParticles((LivingEntity)entity);
                HealT1Spell.spawnHealParticles((LivingEntity)entity);
                HealT1Spell.spawnHealParticles((LivingEntity)entity);
            }
        });
        BiConsumer<AnimationState, DeadTree> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_DEAD_TREE_ROAR.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<DeadTree> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.level().isClientSide) {
            if (anim != null) {
                if (anim.is(new String[]{APPLE_SHIELD})) {
                    this.shieldCooldown = this.getRandom().nextInt(60) + 100;
                }
                if (anim.is(new String[]{HEAL})) {
                    this.healCooldown = this.getRandom().nextInt(80) + 100;
                }
            }
        } else if (anim != null && anim.animation().equals("summon")) {
            int rand = this.random.nextInt(3) + 1;
            AnimationDefinition animNew = AnimationsBuilder.definition((double)anim.length(), (boolean)false).animationId(anim.animation() + "_" + rand).withTransitionTime(anim.startTransition(), anim.endTransition()).speed(anim.speed()).build(anim.id());
            this.getAnimationHandler().setAnimationDef(animNew);
            return true;
        }
        return false;
    });
    private int shieldCooldown;
    private int healCooldown;

    public DeadTree(EntityType<? extends DeadTree> type, Level level) {
        super((EntityType<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.DEAD_TREE.getID(), this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.DEAD_TREE_FIGHT.get());
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new SmoothGroundNavigation((Mob)this, level){

            @Nullable
            protected Path createPath(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                if (!DeadTree.this.canMove()) {
                    return null;
                }
                return super.createPath(targets, regionOffset, offsetUpward, accuracy, followRange);
            }
        };
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.25);
        super.applyAttributes();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SUMMON_ANIMATION, (Object)0);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(ATTACK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(FALLING_APPLES)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged() && MonsterBehaviourUtils.ifCloserThan(16.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(APPLE_SHIELD)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.shieldCooldown <= 0).end(8).start(MonsterBehaviourUtils.checkedAttack(SPIKE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(9).start(MonsterBehaviourUtils.checkedAttack(BIG_FALLING_APPLES)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(MORE_FALLING_APPLES)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(BossMonster::isEnraged, MonsterBehaviourUtils.ifCloserThan(16.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(HEAL)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.healCooldown <= 0).end(6).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) {
            --this.shieldCooldown;
            --this.healCooldown;
        }
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 2.1;
        double length = (double)this.getBbWidth() * 1.85;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public int animationCooldown(String anim) {
        int cooldown = super.animationCooldown(anim);
        if (anim != null && anim.equals(SPIKE)) {
            cooldown += 40;
        }
        return cooldown;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        this.getNavigation().stop();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<DeadTree> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.ROOT_SPIKE_TRIPLE.get())) {
                    this.getAnimationHandler().setAnimation(SPIKE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.APPLE_RAIN.get())) {
                    this.getAnimationHandler().setAnimation(FALLING_APPLES);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    public boolean canMove() {
        return this.isTamed() || this.isEnraged();
    }

    public void push(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, DEFEAT})) {
            return;
        }
        if (!this.canMove()) {
            return;
        }
        super.push(x, y, z);
    }

    @Override
    public double deathRayOffset() {
        return this.getEyeHeight();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)RuneCraftorySounds.ENTITY_DEAD_TREE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)RuneCraftorySounds.ENTITY_DEAD_TREE_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return DEFEAT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

