/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.MarionettaTrapEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.BoundEntityListHandler;
import io.github.flemmli97.runecraftory.common.entities.utils.BoundEntityListListener;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.CardThrowSpell;
import io.github.flemmli97.runecraftory.common.spells.DarkBeamSpell;
import io.github.flemmli97.runecraftory.common.spells.FurnitureThrowSpell;
import io.github.flemmli97.runecraftory.common.spells.PlushThrowSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.DummyBehaviour;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.LeapInDirection;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;

public class Marionetta
extends BossMonster
implements BoundEntityListListener {
    private static final EntityDataAccessor<Boolean> CAUGHT = SynchedEntityData.defineId(Marionetta.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final TypedResource<Vec3> MOVE_DIRECTION = new TypedResource(RuneCraftory.modRes("move_direction"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE = BUILDER.add("melee", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.4}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String SPIN = BUILDER.add("spin", AnimationsBuilder.definition((double)1.68).marker("attack_start", new double[]{0.36}).marker("attack_end", new double[]{1.56}));
    public static final String CARD_ATTACK = BUILDER.add("card_attack", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.48}));
    public static final String CHEST_ATTACK = BUILDER.add("chest_attack", AnimationsBuilder.definition((double)1.08).marker("attack_start", new double[]{0.36}).marker("attack_end", new double[]{0.88}));
    public static final String CHEST_THROW = BUILDER.add("chest_throw", AnimationsBuilder.definition((double)MarionettaTrapEntity.DURATION, (boolean)false).marker("attack", new double[]{0.28}));
    public static final String STUFFED_ANIMALS = BUILDER.add("stuffed_animals", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.52}));
    public static final String DARK_BEAM = BUILDER.add("dark_beam", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.48}));
    public static final String FURNITURE = BUILDER.add("furniture", AnimationsBuilder.definition((double)1.12).marker("attack", new double[]{0.52}));
    public static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)0.6));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.52}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.52}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Marionetta>> ATTACK_HANDLER = Marionetta.createAnimationHandler(b -> {
        b.put((Object)MELEE, (anim, entity) -> {
            LivingEntity target = entity.getTarget();
            if (target != null) {
                entity.getNavigation().moveTo((Entity)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::doHurtTarget);
            }
        });
        b.put((Object)SPIN, (anim, entity) -> {
            entity.getNavigation().stop();
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).scale(0.5));
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.setDeltaMovement(entity.getMoveDirection());
                entity.mobAttack((AnimationState)anim, null, e -> {
                    float strength;
                    if (CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new DynamicDamage.Builder((Entity)entity).hurtResistant(8)) && (strength = (float)(2.0 * (1.0 - e.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)))) > 0.0f) {
                        e.setDeltaMovement(e.getDeltaMovement().add(entity.getMoveDirection().scale((double)strength)));
                    }
                });
            } else {
                entity.setDeltaMovement(entity.getDeltaMovement().scale(0.95));
            }
        });
        b.put((Object)CARD_ATTACK, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((CardThrowSpell)RuneCraftorySpells.CARD_THROW.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)CHEST_ATTACK, (anim, entity) -> {
            entity.getNavigation().stop();
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).scale(0.65));
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.setDeltaMovement(entity.getMoveDirection());
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.getType().is(RunecraftoryTags.EntityTypes.MARIONETTA_TRAP_IGNORE) && !entity.caughtEntities.has((LivingEntity)e)) {
                        entity.catchEntity((LivingEntity)e);
                    }
                });
            }
        });
        b.put((Object)CHEST_THROW, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                Vec3 throwVec = EntityUtils.horizontalLookAngle((Entity)entity).scale(1.8).add(0.0, 1.0, 0.0);
                MarionettaTrapEntity trap = new MarionettaTrapEntity(entity.level(), (LivingEntity)entity);
                trap.setDamageMultiplier(0.8f);
                trap.throwIn(throwVec);
                entity.caughtEntities.forEach(trap::addCaughtEntity);
                entity.level().addFreshEntity((Entity)trap);
                entity.caughtEntities.clear();
            }
        });
        b.put((Object)STUFFED_ANIMALS, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((PlushThrowSpell)RuneCraftorySpells.PLUSH_THROW.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)DARK_BEAM, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack") && !EntityUtils.sealed((LivingEntity)entity)) {
                ((DarkBeamSpell)RuneCraftorySpells.DARK_BEAM.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)FURNITURE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack") && !EntityUtils.sealed((LivingEntity)entity)) {
                ((FurnitureThrowSpell)RuneCraftorySpells.FURNITURE.get()).use((LivingEntity)entity);
            }
        });
        BiConsumer<AnimationState, Marionetta> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_MARIONETTA_ROAR.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Marionetta> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        this.setMoveDirection(null);
        if (((Boolean)this.entityData.get(CAUGHT)).booleanValue() && !this.level().isClientSide) {
            this.entityData.set(CAUGHT, (Object)false);
            this.getAnimationHandler().setAnimation(CHEST_THROW);
            return true;
        }
        return false;
    });
    private final BoundEntityListHandler<Marionetta> caughtEntities = new BoundEntityListHandler<Marionetta>(this);

    public Marionetta(EntityType<? extends Marionetta> type, Level level) {
        super((EntityType<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.MARIONETTA.getID(), this.getDisplayName(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.MARIONETTA_FIGHT.get());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CAUGHT, (Object)false);
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(MOVE_DIRECTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.26);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(MELEE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(5.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(CARD_ATTACK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((entity, target) -> {
            if (entity.distanceToSqr((Entity)target) < 9.0) {
                entity.getAnimationHandler().setAnimation(LEAP);
                return true;
            }
            return false;
        }).strength(1.2).horizontalDirection((entity, target) -> LeapInDirection.createBackwardsVec((Vec3)entity.position(), (Vec3)target.position())).whenStarting(m -> m.getAnimationHandler().setAnimation(LEAP))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(11).start(MonsterBehaviourUtils.checkedAttack(SPIN)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(14)).speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(CHEST_ATTACK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(14)).speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(STUFFED_ANIMALS)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(6.0).speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(DARK_BEAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(12)).speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(6).start(MonsterBehaviourUtils.checkedAttack(FURNITURE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).end(7).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(12, new ExtendedBehaviour[]{DummyBehaviour.opt((ExtendedBehaviour)new InvalidateMemory(MemoryModuleType.WALK_TARGET)), DummyBehaviour.opt((ExtendedBehaviour)new LeapInDirection().shouldLeap((e, t) -> {
            if (e.getRandom().nextFloat() < 4.0f) {
                e.getAnimationHandler().setAnimation(LEAP);
                return true;
            }
            return false;
        }).horizontalDirection((entity, target) -> {
            if (entity.distanceToSqr((Entity)target) <= 5.0) {
                return LeapInDirection.createBackwardsVec((Vec3)entity.position(), (Vec3)target.position());
            }
            return LeapInDirection.createSidewaysVec((Vec3)entity.position(), (Vec3)target.position(), (boolean)entity.getRandom().nextBoolean());
        }).strength(1.2).cooldownFor(e -> 60)), new StrafeTarget().strafeDistance(10.0f)}).add(4, MonsterBehaviourUtils.ifCloserThan(12.0), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().minDist(3.0f).radius(6.0), MonsterBehaviourUtils.moveTo()}).add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected boolean runCooldownBehaviour() {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return (anim == null || anim.is(new String[]{LEAP})) && BrainUtils.hasMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        this.caughtEntities.forEach(entity -> {
            if (entity.isAlive()) {
                entity.setDeltaMovement(Vec3.ZERO);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.moveTo(this.getX(), this.getY() + (double)this.getBbHeight() + 0.2, this.getZ());
                } else {
                    entity.setPos(this.getX(), this.getY() + (double)this.getBbHeight() + 0.2, this.getZ());
                }
                entity.hurtMarked = true;
            }
        });
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        LivingEntity living;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity && this.caughtEntities.has(living = (LivingEntity)entity)) {
            return false;
        }
        return !this.getAnimationHandler().isCurrent(new String[]{CHEST_THROW}) && super.hurt(source, amount);
    }

    public void push(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, DEFEAT})) {
            return;
        }
        super.push(x, y, z);
    }

    public void push(Entity entityIn) {
        if (this.getAnimationHandler().isCurrent(new String[]{SPIN, CHEST_ATTACK})) {
            return;
        }
        super.push(entityIn);
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{SPIN, CHEST_ATTACK})) {
            return this.getMoveDirection();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        Vec3 dir = this.getMoveDirection();
        if (dir == null) {
            dir = target != null ? target.subtract(this.position()) : this.getViewVector(1.0f);
        }
        if (anim.is(new String[]{SPIN})) {
            float rotY = -Mth.wrapDegrees((float)((float)(Mth.atan2((double)dir.x(), (double)dir.z()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).expandTowards(0.0, 0.0, -1.0).inflate(grow + 0.5, 0.1, grow + 1.2), rotY, 0.0f, this.position());
        }
        if (anim.is(new String[]{CHEST_ATTACK})) {
            float rotY = -Mth.wrapDegrees((float)((float)(Mth.atan2((double)dir.x(), (double)dir.z()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(grow + 0.5, 0.1, grow + 1.2), rotY, 0.0f, this.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.5;
        double length = (double)this.getBbWidth() * 1.7;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public int animationCooldown(String anim) {
        int cooldown = super.animationCooldown(anim);
        if (anim.equals(CHEST_ATTACK)) {
            cooldown += Mth.ceil((double)this.getAnimationHandler().get(CHEST_THROW).length());
        }
        return cooldown;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Marionetta> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 2 ? (Spell)RuneCraftorySpells.CARD_THROW.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(CARD_ATTACK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    private void catchEntity(LivingEntity entity) {
        this.caughtEntities.add(entity);
        this.entityData.set(CAUGHT, (Object)true);
    }

    public boolean caughtTarget() {
        return (Boolean)this.entityData.get(CAUGHT);
    }

    public Vec3 getMoveDirection() {
        return (Vec3)this.getDataContainer().get(MOVE_DIRECTION);
    }

    public void setMoveDirection(Vec3 direction) {
        this.getDataContainer().set(MOVE_DIRECTION, (Object)direction);
    }

    @Override
    public double deathRayOffset() {
        return (double)this.getBbHeight() * 0.1;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public BoundEntityListHandler<?> getList() {
        return this.caughtEntities;
    }
}

