/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.SanoUno;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.Uno;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.ExplosionSpell;
import io.github.flemmli97.runecraftory.common.spells.FireWallSpell;
import io.github.flemmli97.runecraftory.common.spells.FireballSpell;
import io.github.flemmli97.runecraftory.common.spells.MultiFireballSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public class Sano
extends SanoUno {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String FIREBALL_3X = BUILDER.add("fireball_3x", AnimationsBuilder.definition((double)2.0).marker("attack", new double[]{0.8, 1.0, 1.2}));
    public static final String FIREBALL_BARRAGE = BUILDER.add("fireball_barrage", AnimationsBuilder.definition((double)4.5).marker("single", new double[]{3.0}).marker("double", new double[]{3.8}).marker("triple", new double[]{0.8}).marker("quad", new double[]{1.2, 3.4}));
    public static final String EXPLOSION = BUILDER.add("explosion", AnimationsBuilder.definition((double)1.5).marker("attack", new double[]{0.8}));
    public static final String FIRE_BREATH = BUILDER.add("fire_breath", AnimationsBuilder.definition((double)2.0).marker("attack", new double[]{0.8, 1.2}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Sano>> ATTACK_HANDLER = Sano.createAnimationHandler(b -> {
        b.put((Object)FIREBALL_3X, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((FireballSpell)RuneCraftorySpells.FIREBALL.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)FIREBALL_BARRAGE, (anim, entity) -> {
            if (anim.isAt("single")) {
                ((FireballSpell)RuneCraftorySpells.FIREBALL.get()).use((LivingEntity)entity);
            }
            if (anim.isAt("double")) {
                ((MultiFireballSpell)RuneCraftorySpells.DOUBLE_FIRE_BALL.get()).use((LivingEntity)entity);
            }
            if (anim.isAt("triple")) {
                ((MultiFireballSpell)RuneCraftorySpells.TRIPLE_FIRE_BALL.get()).use((LivingEntity)entity);
            }
            if (anim.isAt("quad")) {
                ((MultiFireballSpell)RuneCraftorySpells.QUAD_FIRE_BALL.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)EXPLOSION, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((ExplosionSpell)RuneCraftorySpells.EXPLOSION.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)FIRE_BREATH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                Vec3 from = FireWallSpell.offset((LivingEntity)entity);
                Vec3 dir = entity.getTarget() != null ? EntityUtils.getStraightProjectileTarget(from, (Entity)entity.getTarget()).subtract(from).normalize() : entity.getLookAngle();
                dir = dir.scale(10.0).add(entity.random.nextGaussian() * 2.3, -Math.abs(entity.random.nextGaussian()) * 0.6, entity.random.nextGaussian() * 2.3);
                entity.setTargetPosition(TargetPosition.of((Vec3)entity.position().add(dir)));
                ((FireWallSpell)RuneCraftorySpells.FIRE_WALL.get()).use((LivingEntity)entity);
            }
        });
    });
    private final AnimationHandler<Sano> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private Uno other;

    public Sano(EntityType<? extends Sano> type, Level level) {
        super((EntityType<? extends SanoUno>)type, level);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(FIREBALL_3X)).play(MonsterBehaviourUtils.cooldownedPlay()).end(10).start(MonsterBehaviourUtils.checkedAttack(FIREBALL_BARRAGE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(10).start(MonsterBehaviourUtils.checkedAttack(EXPLOSION)).play(MonsterBehaviourUtils.cooldownedPlay()).end(10).start(MonsterBehaviourUtils.checkedAttack(FIRE_BREATH)).play(MonsterBehaviourUtils.cooldownedPlay()).end(10).build();
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Sano> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.FIRE_WALL.get())) {
                    this.getAnimationHandler().setAnimation(FIRE_BREATH);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.FIREBALL_BARRAGE.get())) {
                    this.getAnimationHandler().setAnimation(FIREBALL_BARRAGE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.TRIPLE_FIRE_BALL.get())) {
                this.getAnimationHandler().setAnimation(FIREBALL_3X);
            }
        }
    }

    @Override
    public Uno getLinked() {
        List results;
        if (this.other != null && !this.other.isRemoved()) {
            return this.other;
        }
        if (this.getLinkedID() != null && !(results = this.level().getEntities(EntityTypeTest.forClass(Uno.class), this.getBoundingBox().inflate(64.0), e -> this.getLinkedID().equals(e.getLinkedID()))).isEmpty()) {
            this.other = (Uno)results.getFirst();
        }
        return this.other;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

