/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.ElementalCircleSpell;
import io.github.flemmli97.runecraftory.common.spells.ExpandingLight;
import io.github.flemmli97.runecraftory.common.spells.LightBeamSpell;
import io.github.flemmli97.runecraftory.common.spells.MissileSpell;
import io.github.flemmli97.runecraftory.common.spells.PrismSpell;
import io.github.flemmli97.runecraftory.common.spells.ShineSpell;
import io.github.flemmli97.runecraftory.common.spells.StarFallSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;

public class Sarcophagus
extends BossMonster {
    public static final TypedResource<Vec3> CHARGE_MOTION = new TypedResource(RuneCraftory.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String TELEPORT = BUILDER.add("teleport", AnimationsBuilder.definition((double)2.64).marker("teleport_start_1", new double[]{0.2}).marker("teleport_end_1", new double[]{0.44}).marker("teleport_start_2", new double[]{1.2}).marker("teleport_end_2", new double[]{1.44}).marker("teleport_start_3", new double[]{2.2}).marker("teleport_end_3", new double[]{2.44}).marker("teleport", new double[]{0.28, 1.28, 2.28}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)1.6).marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.48}));
    public static final String BEAM = BUILDER.add("cast", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.48}));
    public static final String LIGHT_2X = BUILDER.add("light_2x", BEAM);
    public static final String LIGHT_4X = BUILDER.add("light_4x", BEAM);
    public static final String SHINE = BUILDER.add("shine", BEAM);
    public static final String PRISM = BUILDER.add("prism", BEAM);
    public static final String INTERACT = BUILDER.add("interact", BEAM);
    public static final String BEAM_3X = BUILDER.add("cast_3x", AnimationsBuilder.definition((double)2.2).marker("attack", new double[]{0.48, 1.24, 2.0}));
    public static final String FIRE_CIRCLE = BUILDER.add("circle_cast", AnimationsBuilder.definition((double)2.32).marker("attack", new double[]{0.4}));
    public static final String WIND_CIRCLE = BUILDER.add("wind_circle", FIRE_CIRCLE);
    public static final String ICE_CIRCLE = BUILDER.add("ice_circle", FIRE_CIRCLE);
    public static final String EARTH_CIRCLE = BUILDER.add("earth_circle", FIRE_CIRCLE);
    public static final String MISSILE = BUILDER.add("missile", AnimationsBuilder.definition((double)1.04).marker("attack", new double[]{0.72}));
    public static final String STARFALL = BUILDER.add("starfall", AnimationsBuilder.definition((double)8.2).marker("attack", new double[]{0.8}).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{7.96}).marker("teleport_start", new double[]{0.2}).marker("teleport_end", new double[]{8.0}));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{1.4}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.1}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Sarcophagus>> ATTACK_HANDLER = Sarcophagus.createAnimationHandler(b -> {
        b.put((Object)TELEPORT, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("teleport_start_1") || anim.isAt("teleport_end_1") || anim.isAt("teleport_start_2") || anim.isAt("teleport_end_2") || anim.isAt("teleport_start_3") || anim.isAt("teleport_end_3")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.GENERIC_TELEPORT.get(), 1.0f, 1.0f);
            }
            if (anim.isAt("teleport")) {
                entity.teleportAround(8, 10);
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<LivingEntity>();
                }
                if (entity.getChargeMotion() == null) {
                    entity.setChargeDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).scale(0.3));
                }
                Vec3 dir = entity.getChargeMotion();
                entity.setDeltaMovement(dir.x(), entity.getDeltaMovement().y(), dir.z());
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new DynamicDamage.Builder((Entity)entity).hurtResistant(5).knock(DynamicDamage.KnockBackType.BACK, 2.0f))) {
                        entity.hitEntity.add((LivingEntity)e);
                    }
                });
                if (entity.tickCount % 5 == 0) {
                    entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (entity.random.nextFloat() - entity.random.nextFloat()) * 0.2f + 1.0f);
                }
            } else {
                entity.setDeltaMovement(entity.getDeltaMovement().scale(0.6));
            }
        });
        b.put((Object)BEAM, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((LightBeamSpell)RuneCraftorySpells.LIGHT_BEAM.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)BEAM_3X, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((LightBeamSpell)RuneCraftorySpells.LIGHT_BEAM.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)FIRE_CIRCLE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((ElementalCircleSpell)RuneCraftorySpells.FIRE_CIRCLE.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)WIND_CIRCLE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((ElementalCircleSpell)RuneCraftorySpells.WIND_CIRCLE.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)ICE_CIRCLE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((ElementalCircleSpell)RuneCraftorySpells.ICE_CIRCLE.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)EARTH_CIRCLE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((ElementalCircleSpell)RuneCraftorySpells.EARTH_CIRCLE.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)LIGHT_2X, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((ExpandingLight)RuneCraftorySpells.EXPANDING_DOUBLE_LIGHT.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)LIGHT_4X, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((ExpandingLight)RuneCraftorySpells.EXPANDING_QUAD_LIGHT.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)SHINE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((ShineSpell)RuneCraftorySpells.SHINE.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)PRISM, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((PrismSpell)RuneCraftorySpells.PRISM_LONG.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)MISSILE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((MissileSpell)RuneCraftorySpells.MISSILE_8X.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)STARFALL, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack_start")) {
                entity.starFallPre = entity.position();
                if (entity.hasRestriction()) {
                    Vec3 pos = Vec3.atCenterOf((Vec3i)entity.getRestrictCenter());
                    entity.teleportTo(pos.x, pos.y + 8.0, pos.z);
                } else if (entity.getTarget() != null) {
                    entity.teleportTo(entity.getTarget().getX(), entity.getTarget().getY() + 8.0, entity.getTarget().getZ());
                } else {
                    entity.teleportTo(entity.getX(), entity.getY() + 8.0, entity.getZ());
                }
                entity.starFallPos = entity.position();
                ((StarFallSpell)RuneCraftorySpells.STARFALL_LONG.get()).use((LivingEntity)entity);
            }
            if (entity.starFallPos != null) {
                entity.setPos(entity.starFallPos);
            }
            if (anim.isAt("attack_end")) {
                entity.teleportTo(entity.starFallPre.x(), entity.starFallPre.y(), entity.starFallPre.z());
                entity.starFallPre = null;
                entity.starFallPos = null;
                entity.teleportAround(6, 12);
            }
        });
        b.put((Object)SPAWN, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playRandomizedSound(SoundEvents.LIGHTNING_BOLT_THUNDER);
                entity.playRandomizedSound(SoundEvents.LIGHTNING_BOLT_IMPACT);
            }
        });
        b.put((Object)ANGRY, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_SARCOPHAGUS_ROAR.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
            }
        });
    });
    private final AnimationHandler<Sarcophagus> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        this.hitEntity = null;
        if (anim != null) {
            if (this.forceSetNextAttack != null && anim.is(new String[]{this.forceSetNextAttack})) {
                this.forceSetNextAttack = null;
            }
            this.teleported = anim.is(new String[]{TELEPORT});
            if (!anim.is(new String[]{TELEPORT})) {
                this.previousAttack = anim.id();
            }
            if (anim.is(new String[]{CHARGE})) {
                this.setChargeDirection(null);
                this.getAttribute(Attributes.STEP_HEIGHT).addTransientModifier(new AttributeModifier(LibConstants.STEP_UP_TEMP, 1.0, AttributeModifier.Operation.ADD_VALUE));
            }
            if (anim.is(new String[]{STARFALL})) {
                this.gravityPre = this.isNoGravity();
                this.starfallCooldown = 240 + this.getRandom().nextInt(400);
                this.setNoGravity(true);
            }
        } else {
            this.getAttribute(Attributes.STEP_HEIGHT).removeModifier(LibConstants.STEP_UP_TEMP);
            if (this.getAnimationHandler().isCurrent(new String[]{STARFALL})) {
                this.setNoGravity(this.gravityPre);
            }
        }
        return false;
    });
    protected List<LivingEntity> hitEntity;
    private Vec3 starFallPre;
    private Vec3 starFallPos;
    private boolean teleported;
    private boolean gravityPre;
    private String previousAttack = "";
    private String forceSetNextAttack;
    private int starfallCooldown;

    public Sarcophagus(EntityType<? extends Sarcophagus> type, Level level) {
        super((EntityType<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.SARCOPHAGUS.getID(), this.getDisplayName(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.SARCOPHAGUS_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.26);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(((Attribute)Attributes.STEP_HEIGHT.value()).getDefaultValue() + 1.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(TELEPORT)).play(MonsterBehaviourUtils.cooldownedPlay()).end(11).start(MonsterBehaviourUtils.checkedAttack(CHARGE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(5.0)).end(7).start(MonsterBehaviourUtils.checkedAttack(BEAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged()).end(8).start(MonsterBehaviourUtils.checkedAttack(BEAM_3X)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).end(8).start(MonsterBehaviourUtils.checkedAttack(FIRE_CIRCLE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(4).start(MonsterBehaviourUtils.checkedAttack(WIND_CIRCLE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(4).start(MonsterBehaviourUtils.checkedAttack(ICE_CIRCLE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(4).start(MonsterBehaviourUtils.checkedAttack(EARTH_CIRCLE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(4).start(MonsterBehaviourUtils.checkedAttack(LIGHT_2X)).play(MonsterBehaviourUtils.cooldownedPlay()).end(7).start(MonsterBehaviourUtils.checkedAttack(LIGHT_4X)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).end(7).start(MonsterBehaviourUtils.checkedAttack(SHINE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged()).end(7).start(MonsterBehaviourUtils.checkedAttack(PRISM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).end(7).start(MonsterBehaviourUtils.checkedAttack(MISSILE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(7).start(MonsterBehaviourUtils.checkedAttack(STARFALL)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && m.starfallCooldown <= 0).end(20).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomWalkTarget().speedModifier(0.7f);
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
            this.forceSetNextAttack = STARFALL;
        }
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) {
            --this.starfallCooldown;
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return !this.isTeleporting() && super.hurt(source, amount);
    }

    @Override
    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE})) {
            if (this.getAnimationHandler().getAnimation().isPast("attack_start")) {
                return this.getChargeMotion();
            }
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{CHARGE})) {
            double width = this.getBbWidth();
            double speed = Math.max(width, this.getDeltaMovement().length() - width);
            float rotY = -Mth.wrapDegrees((float)((float)(Mth.atan2((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().z()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(grow + 0.4, 0.1, grow + 0.4).expandTowards(0.0, 0.0, speed), rotY, 0.0f, this.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public int animationCooldown(String anim) {
        if (TELEPORT.equals(anim)) {
            return 7 + this.getRandom().nextInt(6);
        }
        return super.animationCooldown(anim);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Sarcophagus> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.FIRE_CIRCLE.get())) {
                    this.getAnimationHandler().setAnimation(FIRE_CIRCLE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.MISSILE_8X.get())) {
                    this.getAnimationHandler().setAnimation(MISSILE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.LIGHT_BEAM.get())) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
        }
    }

    @Override
    public boolean allowAnimation(String prev, String other) {
        if (this.forceSetNextAttack != null) {
            return other.equals(this.forceSetNextAttack);
        }
        if (!this.teleported) {
            return TELEPORT.equals(other);
        }
        return !TELEPORT.equals(other) && !this.previousAttack.equals(other);
    }

    public void push(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, DEFEAT, TELEPORT, STARFALL})) {
            return;
        }
        super.push(x, y, z);
    }

    public boolean shouldRender(double x, double y, double z) {
        if (this.isTeleporting()) {
            return false;
        }
        return super.shouldRender(x, y, z);
    }

    private boolean isTeleporting() {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        if (anim == null) {
            return false;
        }
        if (anim.is(new String[]{TELEPORT})) {
            if (anim.isPast("teleport_start_1") && !anim.isPast("teleport_end_1")) {
                return true;
            }
            if (anim.isPast("teleport_start_2") && !anim.isPast("teleport_end_2")) {
                return true;
            }
            return anim.isPast("teleport_start_3") && !anim.isPast("teleport_end_3");
        }
        if (anim.is(new String[]{STARFALL})) {
            return anim.isPast("teleport_start") && !anim.isPast("teleport_end");
        }
        return false;
    }

    private void teleportAround(int range, int yRange) {
        Vec3 pos = this.hasRestriction() ? Vec3.atCenterOf((Vec3i)this.getRestrictCenter()) : (this.getTarget() != null ? this.getTarget().position() : this.position());
        for (int i = 0; i < 10; ++i) {
            double x = pos.x() + (this.getRandom().nextDouble() * 2.0 - 1.0) * (double)range;
            double y = pos.y() + 4.0;
            double z = pos.z() + (this.getRandom().nextDouble() * 2.0 - 1.0) * (double)range;
            if (this.hasRestriction() && this.getRestrictCenter().distToCenterSqr(x, y, z) > (double)(this.getRestrictRadius() * this.getRestrictRadius()) || !this.teleport(x, y, z, yRange)) continue;
            return;
        }
    }

    private boolean teleport(double x, double y, double z, int yRange) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y - 1.0, z);
        ChunkAccess chunk = this.level().getChunk((BlockPos)pos);
        while (yRange > 0 && pos.getY() > this.level().getMinBuildHeight() && !chunk.getBlockState((BlockPos)pos).blocksMotion()) {
            pos.move(Direction.DOWN);
            --yRange;
            y -= 1.0;
        }
        BlockState blockState = chunk.getBlockState((BlockPos)pos);
        if (!blockState.blocksMotion()) {
            return false;
        }
        Vec3 current = this.position();
        this.teleportTo(x, y, z);
        if (!this.level().noCollision((Entity)this) || this.level().containsAnyLiquid(this.getBoundingBox())) {
            this.teleportTo(current.x(), current.y(), current.z());
            return false;
        }
        return true;
    }

    public Vec3 getChargeMotion() {
        return (Vec3)this.getDataContainer().get(CHARGE_MOTION);
    }

    protected void setChargeDirection(Vec3 moveDirection) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)moveDirection);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

