/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.SlashResidueEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.MultiPartContainer;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.particles.SkelefangParticleData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.BoneNeedleSpell;
import io.github.flemmli97.runecraftory.common.spells.EnergyOrbSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.MultiPartEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.EntityFollowData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector3f;

public class Skelefang
extends BossMonster {
    public static final byte HEAD_DROP = 70;
    public static final byte HEAD_THROW = 71;
    public static final byte NECK_DROP = 72;
    public static final byte NECK_THROW = 73;
    public static final byte FRONT = 74;
    public static final byte FRONT_RIBS = 75;
    public static final byte LEFT_LEG = 76;
    public static final byte RIGHT_LEG = 77;
    public static final byte BACK = 78;
    public static final byte BACK_RIBS = 79;
    public static final byte TAIL = 80;
    public static final byte TAIL_BASE = 81;
    public static final byte HIT = 82;
    public static final byte SHATTER = 83;
    public static final byte CHARGE_BEAM = 84;
    private static final EntityDataAccessor<Integer> HEAD_BONES = SynchedEntityData.defineId(Skelefang.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TAIL_BONES = SynchedEntityData.defineId(Skelefang.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LEFT_LEG_BONES = SynchedEntityData.defineId(Skelefang.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> RIGHT_LEG_BONES = SynchedEntityData.defineId(Skelefang.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BODY_BONES = SynchedEntityData.defineId(Skelefang.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String TAIL_SLAM = BUILDER.add("tail_slam", AnimationsBuilder.definition((double)2.0).marker("attack_1", new double[]{0.72}).marker("attack_2", new double[]{1.2}).marker("attack_3", new double[]{1.64}));
    public static final String INTERACT = BUILDER.add("interact", TAIL_SLAM);
    public static final String NEEDLE_THROW = BUILDER.add("needle_throw", AnimationsBuilder.definition((double)1.24).marker("attack", new double[]{0.88}));
    public static final String TAIL_SLAP = BUILDER.add("tail_slap", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.6}));
    public static final String SLASH = BUILDER.add("slash", AnimationsBuilder.definition((double)1.04).marker("attack", new double[]{0.68}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)1.76).marker("attack_start", new double[]{0.4}));
    public static final String BEAM = BUILDER.add("beam", AnimationsBuilder.definition((double)13.0).marker("charge", new double[]{4.5}).marker("beam", new double[]{6.5}).marker("restore_start", new double[]{11.0}).marker("restore_end", new double[]{12.0}).marker("restore", new double[]{11.5}));
    public static final String DEATH = BUILDER.add("death", AnimationsBuilder.definition((double)10.0).infinite());
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.24}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.24}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Skelefang>> ATTACK_HANDLER = Skelefang.createAnimationHandler(b -> {
        b.put((Object)TAIL_SLAM, (anim, entity) -> {
            block2: {
                block3: {
                    if (entity.remainingTailBones() <= 10 && !entity.isEnraged()) break block2;
                    if (anim.isAt("attack_1") || anim.isAt("attack_2")) break block3;
                    if (!anim.isAt("attack_3")) break block2;
                }
                entity.mobAttack((AnimationState)anim, entity.getTarget(), entity::doHurtTarget);
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)RuneCraftorySounds.ENTITY_SKELEFANG_SWEEP.get(), entity.getSoundSource(), 2.0f, 1.0f);
            }
        });
        b.put((Object)NEEDLE_THROW, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((BoneNeedleSpell)RuneCraftorySpells.BONE_NEEDLES.get()).use((LivingEntity)entity);
                if (entity.remainingHeadBones() > 10) {
                    entity.level().broadcastEntityEvent((Entity)entity, (byte)71);
                    entity.setHeadBones(10, false);
                } else if (entity.remainingHeadBones() > 0) {
                    entity.level().broadcastEntityEvent((Entity)entity, (byte)73);
                    entity.setHeadBones(0, false);
                }
            }
        });
        b.put((Object)TAIL_SLAP, (anim, entity) -> {
            if ((entity.remainingTailBones() > 10 || entity.isEnraged()) && anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, entity.getTarget(), entity::doHurtTarget);
            }
        });
        b.put((Object)SLASH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                SlashResidueEntity slash;
                Vec3 side;
                Vec3 dir;
                entity.mobAttack((AnimationState)anim, entity.getTarget(), entity::doHurtTarget);
                LivingEntity patt0$temp = entity.getControllingPassenger();
                if (patt0$temp instanceof Player) {
                    Player player = (Player)patt0$temp;
                    dir = Vec3.directionFromRotation((float)0.0f, (float)player.yBodyRot);
                    side = Vec3.directionFromRotation((float)0.0f, (float)(player.yBodyRot + 90.0f));
                } else {
                    dir = Vec3.directionFromRotation((float)0.0f, (float)entity.yBodyRot);
                    side = Vec3.directionFromRotation((float)0.0f, (float)(entity.yBodyRot + 90.0f));
                }
                dir = dir.scale((double)entity.getBbWidth() * 0.5 + 1.0);
                if (entity.remainingLeftLegBones() > 0) {
                    Vec3 leftPos = entity.position().add(dir).add(side.scale(-1.3));
                    slash = new SlashResidueEntity(entity.level(), (LivingEntity)entity);
                    slash.setSize(2.0f);
                    slash.dummy();
                    slash.setPos(leftPos.x, leftPos.y, leftPos.z);
                    slash.setXRot(0.0f);
                    slash.setYRot(entity.yBodyRot);
                    entity.level().addFreshEntity((Entity)slash);
                }
                if (entity.remainingRightLegBones() > 0) {
                    Vec3 rightPos = entity.position().add(dir).add(side.scale(1.3));
                    slash = new SlashResidueEntity(entity.level(), (LivingEntity)entity);
                    slash.setSize(2.0f);
                    slash.dummy();
                    slash.setPos(rightPos.x, rightPos.y, rightPos.z);
                    slash.setXRot(0.0f);
                    slash.setYRot(entity.yBodyRot);
                    entity.level().addFreshEntity((Entity)slash);
                }
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (entity.hitEntity == null) {
                entity.hitEntity = new ArrayList<LivingEntity>();
            }
            if (anim.isPast("attack_start")) {
                Vec3 dir = entity.getTarget() != null ? entity.getTarget().position().subtract(entity.position()) : Vec3.directionFromRotation((float)0.0f, (float)entity.getYRot());
                if ((dir = new Vec3(dir.x(), 0.0, dir.z())).lengthSqr() < 0.5) {
                    entity.setDeltaMovement(0.0, entity.getDeltaMovement().y, 0.0);
                } else {
                    dir = dir.normalize().scale(entity.getAttributeValue(Attributes.MOVEMENT_SPEED) * 1.3);
                    entity.setDeltaMovement(dir.x(), entity.getDeltaMovement().y, dir.z());
                }
                if (entity.tickCount % 5 == 0) {
                    entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (entity.random.nextFloat() - entity.random.nextFloat()) * 0.2f + 1.0f);
                    S2CScreenShake.sendAround((Entity)entity, 24.0, 10, 1.0f);
                }
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new DynamicDamage.Builder((Entity)entity).hurtResistant(5).knock(DynamicDamage.KnockBackType.UP, 0.7f).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.STUN.asHolder(), 70.0))) {
                        entity.hitEntity.add((LivingEntity)e);
                    }
                });
            }
        });
        b.put((Object)BEAM, (anim, entity) -> {
            if (anim.isAt("charge")) {
                entity.level().broadcastEntityEvent((Entity)entity, (byte)84);
            }
            if (anim.isAt("beam")) {
                ((EnergyOrbSpell)RuneCraftorySpells.ENERGY_ORB_SPELL.get()).use((LivingEntity)entity);
            }
            if (anim.isAt("restore")) {
                entity.restoreDragon();
            }
        });
        BiConsumer<AnimationState, Skelefang> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playRandomizedSound((SoundEvent)RuneCraftorySounds.ENTITY_SKELEFANG_ROAR.get());
                S2CScreenShake.sendAround((Entity)entity, 32.0, 40, 2.0f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Skelefang> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (anim != null) {
            this.hitEntity = null;
        }
        if (!this.level().isClientSide && anim == null) {
            boolean chain = !this.commanded;
            this.commanded = false;
            if (chain && this.getAnimationHandler().isCurrent(new String[]{NEEDLE_THROW})) {
                if (!this.isEnraged() || this.needleChain >= 2 || this.needleChain == 1 && (double)this.getRandom().nextFloat() > 0.25) {
                    this.needleChain = 0;
                    return false;
                }
                this.getAnimationHandler().setAnimation(NEEDLE_THROW);
                ++this.needleChain;
                return true;
            }
        }
        return false;
    });
    protected List<LivingEntity> hitEntity;
    private int hurtResist;
    private boolean ignoreHurt;
    private boolean commanded;
    private int needleChain;
    private final MultiPartContainer head = new MultiPartContainer(() -> new MultiPartEntity((EntityType)RuneCraftoryEntities.MULTIPART.get(), (LivingEntity)this, 1.6f, 1.3f).updatePosition(new Vec3(0.0, 2.15, 2.9)));
    private final MultiPartContainer back = new MultiPartContainer(() -> new MultiPartEntity((EntityType)RuneCraftoryEntities.MULTIPART.get(), (LivingEntity)this, 1.6f, 1.5f).updatePosition(new Vec3(0.0, 1.0, -1.5)));
    private final MultiPartContainer rightLeg;
    private final MultiPartContainer leftLeg = new MultiPartContainer(() -> new MultiPartEntity((EntityType)RuneCraftoryEntities.MULTIPART.get(), (LivingEntity)this, 1.6f, 2.5f).updatePosition(new Vec3(1.2, 0.0, 0.0)));

    public Skelefang(EntityType<? extends Skelefang> type, Level level) {
        super((EntityType<? extends BossMonster>)type, level);
        this.rightLeg = new MultiPartContainer(() -> new MultiPartEntity((EntityType)RuneCraftoryEntities.MULTIPART.get(), (LivingEntity)this, 1.6f, 2.5f).updatePosition(new Vec3(-1.2, 0.0, 0.0)));
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.SKELEFANG.getID(), this.getDisplayName(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.SKELEFANG_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
        super.applyAttributes();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEAD_BONES, (Object)20);
        builder.define(TAIL_BONES, (Object)20);
        builder.define(LEFT_LEG_BONES, (Object)20);
        builder.define(RIGHT_LEG_BONES, (Object)20);
        builder.define(BODY_BONES, (Object)20);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(BODY_BONES) && !this.hasBones()) {
            this.ignoreHurt = true;
        }
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(TAIL_SLAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> (m.isEnraged() || m.remainingTailBones() > 10) && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(3))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(12).start(MonsterBehaviourUtils.checkedAttack(TAIL_SLAP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> (m.isEnraged() || m.remainingTailBones() > 10) && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(3))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(NEEDLE_THROW)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(13))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(SLASH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> (m.remainingLeftLegBones() > 0 || m.remainingRightLegBones() > 0) && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(2))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(8).start(MonsterBehaviourUtils.checkedAttack(CHARGE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(15.0)).end(11).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("HeadBones", this.remainingHeadBones());
        compound.putInt("TailBones", this.remainingTailBones());
        compound.putInt("LeftLegBones", this.remainingLeftLegBones());
        compound.putInt("RightLegBones", this.remainingRightLegBones());
        compound.putInt("BodyBones", this.remainingBodyBones());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(HEAD_BONES, (Object)compound.getInt("HeadBones"));
        this.entityData.set(TAIL_BONES, (Object)compound.getInt("TailBones"));
        this.entityData.set(LEFT_LEG_BONES, (Object)compound.getInt("LeftLegBones"));
        this.entityData.set(RIGHT_LEG_BONES, (Object)compound.getInt("RightLegBones"));
        this.entityData.set(BODY_BONES, (Object)compound.getInt("BodyBones"));
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    protected boolean checkRage() {
        return false;
    }

    @Override
    protected void actuallyHurt(DamageSource source, float damageAmount) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            super.actuallyHurt(source, damageAmount);
            if (this.isDeadOrDying()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)83);
            }
            return;
        }
        if (this.hurtResist > 0) {
            return;
        }
        this.hurtResist = 2;
        if (this.hasBones()) {
            if (damageAmount > 4.0f) {
                int amount;
                int boneDamage = 7;
                if (this.remainingTailBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingTailBones());
                    boneDamage -= amount;
                    this.setTailBones(this.remainingTailBones() - amount);
                }
                if (this.remainingLeftLegBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingLeftLegBones());
                    boneDamage -= amount;
                    this.setLeftLegBones(this.remainingLeftLegBones() - amount);
                }
                if (this.remainingRightLegBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingRightLegBones());
                    boneDamage -= amount;
                    this.setRightLegBones(this.remainingRightLegBones() - amount);
                }
                if (this.remainingHeadBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingHeadBones());
                    boneDamage -= amount;
                    this.setHeadBones(this.remainingHeadBones() - amount);
                }
                if (this.remainingBodyBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingBodyBones());
                    this.setBodyBones(this.remainingBodyBones() - amount);
                }
            }
            if (this.isDeadOrDying()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)83);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)82);
            }
            if (!this.hasBones()) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
        } else {
            super.actuallyHurt(source, damageAmount);
        }
    }

    public void setTailBones(int amount) {
        int pre = (Integer)this.entityData.get(TAIL_BONES);
        this.entityData.set(TAIL_BONES, (Object)Math.min(amount, 20));
        if (pre > 10 && amount <= 10) {
            this.level().broadcastEntityEvent((Entity)this, (byte)80);
        }
        if (amount <= 0) {
            this.level().broadcastEntityEvent((Entity)this, (byte)81);
        }
    }

    public void setLeftLegBones(int amount) {
        this.entityData.set(LEFT_LEG_BONES, (Object)Math.min(amount, 20));
        if (amount <= 0) {
            this.level().broadcastEntityEvent((Entity)this, (byte)76);
        }
    }

    public void setRightLegBones(int amount) {
        this.entityData.set(RIGHT_LEG_BONES, (Object)Math.min(amount, 20));
        if (amount <= 0) {
            this.level().broadcastEntityEvent((Entity)this, (byte)77);
        }
    }

    public void setHeadBones(int amount) {
        this.setHeadBones(amount, true);
    }

    public void setBodyBones(int amount) {
        int pre = (Integer)this.entityData.get(BODY_BONES);
        this.entityData.set(BODY_BONES, (Object)Math.min(amount, 20));
        if (pre > 15 && amount <= 15) {
            this.level().broadcastEntityEvent((Entity)this, (byte)79);
        }
        if (pre > 10 && amount <= 10) {
            this.level().broadcastEntityEvent((Entity)this, (byte)78);
        }
        if (pre > 5 && amount <= 5) {
            this.level().broadcastEntityEvent((Entity)this, (byte)75);
        }
        if (amount <= 0) {
            this.level().broadcastEntityEvent((Entity)this, (byte)74);
        }
    }

    private void setHeadBones(int amount, boolean withParticle) {
        int pre = (Integer)this.entityData.get(HEAD_BONES);
        this.entityData.set(HEAD_BONES, (Object)Math.min(amount, 20));
        if (withParticle) {
            if (pre > 10 && amount <= 10) {
                this.level().broadcastEntityEvent((Entity)this, (byte)70);
            }
            if (amount <= 0) {
                this.level().broadcastEntityEvent((Entity)this, (byte)72);
            }
        }
    }

    public void restoreDragon() {
        this.entityData.set(HEAD_BONES, (Object)20);
        this.entityData.set(TAIL_BONES, (Object)20);
        this.entityData.set(LEFT_LEG_BONES, (Object)20);
        this.entityData.set(RIGHT_LEG_BONES, (Object)20);
        this.entityData.set(BODY_BONES, (Object)20);
    }

    public boolean checkIgnoreHurtOverlay() {
        if (this.ignoreHurt) {
            this.ignoreHurt = false;
            return true;
        }
        return false;
    }

    public boolean hasBones() {
        return this.remainingHeadBones() > 0 || this.remainingTailBones() > 0 || this.remainingLeftLegBones() > 0 || this.remainingRightLegBones() > 0 || this.remainingBodyBones() > 0;
    }

    public int remainingHeadBones() {
        return (Integer)this.entityData.get(HEAD_BONES);
    }

    public int remainingTailBones() {
        return (Integer)this.entityData.get(TAIL_BONES);
    }

    public int remainingLeftLegBones() {
        return (Integer)this.entityData.get(LEFT_LEG_BONES);
    }

    public int remainingRightLegBones() {
        return (Integer)this.entityData.get(RIGHT_LEG_BONES);
    }

    public int remainingBodyBones() {
        return (Integer)this.entityData.get(BODY_BONES);
    }

    @Override
    public void handleEntityEvent(byte id) {
        switch (id) {
            case 70: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.HEAD, this.getXRot(), this.yHeadRot, 1.0f, 0.0f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 71: {
                Vec3 look = Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot);
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.HEAD, this.getXRot(), this.yHeadRot, -2.0f, 0.0f, 40, false), this.getX(), this.getY(), this.getZ(), look.x, look.y, look.z);
                break;
            }
            case 72: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.NECK, this.getXRot(), this.yHeadRot, 1.0f, this.random.nextInt(2) - 1), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 73: {
                Vec3 look = Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot);
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.NECK, this.getXRot(), this.yHeadRot, -2.0f, 0.0f, 40, false), this.getX(), this.getY(), this.getZ(), look.x, look.y, look.z);
                break;
            }
            case 74: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.FRONT, this.getXRot(), this.yBodyRot, this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 75: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.FRONT_RIBS, this.getXRot(), this.yBodyRot, this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 76: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.LEFT_LEG, this.getXRot(), this.yBodyRot, this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 77: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.RIGHT_LEG, this.getXRot(), this.yBodyRot, this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 78: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.BACK, this.getXRot(), this.yBodyRot, this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 79: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.BACK_RIBS, this.getXRot(), this.yBodyRot, this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 80: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.TAIL, this.getXRot(), this.yBodyRot, this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 81: {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.TAIL_BASE, this.getXRot(), this.yBodyRot, this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 82: {
                int amount = this.random.nextInt(6) + 12;
                for (int i = 0; i < amount; ++i) {
                    SkelefangParticleData.SkelefangBoneType type = (double)this.random.nextFloat() < 0.4 ? SkelefangParticleData.SkelefangBoneType.GENERIC : SkelefangParticleData.SkelefangBoneType.GENERIC2;
                    this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(type, this.getXRot() + (float)this.random.nextInt(40) - 20.0f, this.yHeadRot + (float)this.random.nextInt(360), this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getRandomX(1.3), this.getY(0.5) + (double)this.getBbHeight() * 0.5, this.getRandomZ(1.3), this.random.nextGaussian() * 0.11, this.random.nextGaussian() * 0.11, this.random.nextGaussian() * 0.11);
                }
                break;
            }
            case 83: {
                int amount = this.random.nextInt(15) + 35;
                if (this.hasBones()) {
                    for (int i = 0; i < amount; ++i) {
                        SkelefangParticleData.SkelefangBoneType type = (double)this.random.nextFloat() < 0.4 ? SkelefangParticleData.SkelefangBoneType.GENERIC : SkelefangParticleData.SkelefangBoneType.GENERIC2;
                        this.level().addAlwaysVisibleParticle((ParticleOptions)new SkelefangParticleData(type, this.getXRot() + (float)this.random.nextInt(40) - 20.0f, this.yHeadRot + (float)this.random.nextInt(360), this.random.nextInt(2) - 1, this.random.nextInt(2) - 1), this.getRandomX(1.3), this.getY(0.5) + (double)this.getBbHeight() * 0.5, this.getRandomZ(1.3), this.random.nextGaussian() * 0.13, this.random.nextGaussian() * 0.13, this.random.nextGaussian() * 0.13);
                    }
                }
                if (this.remainingHeadBones() > 10) {
                    this.handleEntityEvent((byte)70);
                }
                if (this.remainingHeadBones() > 0) {
                    this.handleEntityEvent((byte)72);
                }
                if (this.remainingBodyBones() > 0) {
                    this.handleEntityEvent((byte)74);
                }
                if (this.remainingBodyBones() > 5) {
                    this.handleEntityEvent((byte)75);
                }
                if (this.remainingBodyBones() > 10) {
                    this.handleEntityEvent((byte)78);
                }
                if (this.remainingBodyBones() > 15) {
                    this.handleEntityEvent((byte)79);
                }
                if (this.remainingLeftLegBones() > 0) {
                    this.handleEntityEvent((byte)76);
                }
                if (this.remainingRightLegBones() > 0) {
                    this.handleEntityEvent((byte)77);
                }
                if (this.remainingTailBones() > 0) {
                    this.handleEntityEvent((byte)81);
                }
                if (this.remainingTailBones() <= 10) break;
                this.handleEntityEvent((byte)80);
                break;
            }
            case 84: {
                Vec3 center = this.position().add(0.0, (double)this.getBbHeight() * 0.5, 0.0);
                ArrayList locations = new ArrayList();
                double speed = (this.getBbWidth() + 2.0f) / 40.0f;
                locations.addAll(MathUtils.rotatedVecs((Vector3f)MathUtils.NORMAL_X.scale((double)this.getBbWidth() * 1.5).toVector3f(), (Vector3f)MathUtils.NORMAL_Z.toVector3f(), (float)-180.0f, (float)180.0f, (float)10.0f));
                locations.addAll(MathUtils.rotatedVecs((Vector3f)MathUtils.NORMAL_X.scale((double)this.getBbWidth() * 1.5).toVector3f(), (Vector3f)MathUtils.NORMAL_Y.toVector3f(), (float)-180.0f, (float)180.0f, (float)10.0f));
                locations.addAll(MathUtils.rotatedVecs((Vector3f)MathUtils.NORMAL_Y.scale((double)this.getBbWidth() * 1.5).toVector3f(), (Vector3f)MathUtils.NORMAL_X.toVector3f(), (float)-180.0f, (float)180.0f, (float)10.0f));
                for (Vector3f vec : locations) {
                    Vec3 pos = center.add((double)vec.x(), (double)vec.y(), (double)vec.z());
                    Vec3 dir = new Vec3((double)(-vec.x()), (double)(-vec.y()), (double)(-vec.z())).normalize().scale(speed);
                    AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.8509804f, 0.972549f, 0.9882353f, 0.4f)).addData((AdvancedParticleData)new MotionData(dir)).addData((AdvancedParticleData)new EntityFollowData((Entity)this, true)).addData((AdvancedParticleData)new ScaleData(0.3f)).addData((AdvancedParticleData)new ParticleMetaData(40, false, 0.0f)).add(this.level(), pos.x(), pos.y(), pos.z());
                }
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
        if (this.hurtDuration == 10 && this.checkIgnoreHurtOverlay()) {
            this.hurtDuration = 0;
        }
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) {
            --this.hurtResist;
            this.updateParts();
            if (!(this.isDeadOrDying() || this.hasBones() || this.getAnimationHandler().isCurrent(new String[]{BEAM}))) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
            if (this.isAlive() && !this.getAnimationHandler().hasAnimation() && !this.isTamed() && (double)(this.getHealth() / this.getMaxHealth()) < 0.5 && !this.isEnraged()) {
                this.setEnraged(true, false);
            }
        }
    }

    private void updateParts() {
        if (this.remainingTailBones() > 0) {
            this.back.tick();
        } else {
            this.back.removeEntity();
        }
        if (this.remainingHeadBones() > 10) {
            this.head.tick();
        } else {
            this.head.removeEntity();
        }
        if (this.remainingLeftLegBones() > 0) {
            this.leftLeg.tick();
        } else {
            this.leftLeg.removeEntity();
        }
        if (this.remainingRightLegBones() > 0) {
            this.rightLeg.tick();
        } else {
            this.rightLeg.removeEntity();
        }
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE})) {
            AnimationState anim = this.getAnimationHandler().getAnimation();
            if (!anim.isPast("attack_start")) {
                if (this.getTarget() == null) {
                    return null;
                }
                return this.getTarget().getEyePosition().subtract(this.getEyePosition());
            }
            return this.getDeltaMovement();
        }
        return super.directionToLookAt();
    }

    @Override
    public int animationCooldown(String anim) {
        int diffAdd = this.difficultyCooldown();
        return (this.isEnraged() ? 25 + this.getRandom().nextInt(20) : 35 + this.getRandom().nextInt(30)) + diffAdd;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        this.getNavigation().stop();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void mobAttack(AnimationState anim, LivingEntity target, Consumer<LivingEntity> cons) {
        if (anim.is(new String[]{CHARGE})) {
            double width = this.getBbWidth();
            double speed = Math.max(width, this.getDeltaMovement().length() - width);
            OrientedBoundingBox obb = new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(0.8, 0.0, 0.2).expandTowards(0.0, 0.0, speed), this.getYRot(), 0.0f, this.position());
            this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.hitPred.test(entity) && obb.intersects(entity.getBoundingBox())).forEach(cons);
            if (!this.level().isClientSide) {
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
            }
            return;
        }
        ArrayList<OrientedBoundingBox> obbs = new ArrayList<OrientedBoundingBox>();
        if (anim.is(new String[]{TAIL_SLAP})) {
            double range = this.getBbWidth() + 5.0f;
            obbs.add(new OrientedBoundingBox(new AABB(-range * 0.75, -0.02, 0.0, range * 0.75, 1.82, range), this.getYRot(), 0.0f, this.position()));
        }
        if (anim.is(new String[]{TAIL_SLAM})) {
            float angle = this.yHeadRot - 5.0f;
            LivingEntity livingEntity = this.getControllingPassenger();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                angle = player.yHeadRot;
            }
            if (anim.isAt("attack_3")) {
                angle += 20.0f;
            } else if (!anim.isAt("attack_2")) {
                angle -= 35.0f;
            }
            obbs.add(new OrientedBoundingBox(new AABB(-1.25, -0.02, 0.0, 1.25, 2.12, 7.0), angle, 0.0f, this.position()));
        }
        if (anim.is(new String[]{SLASH})) {
            Vec3 side;
            Vec3 dir;
            double reach = 1.0;
            LivingEntity livingEntity = this.getControllingPassenger();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                dir = Vec3.directionFromRotation((float)0.0f, (float)player.yBodyRot);
                side = Vec3.directionFromRotation((float)0.0f, (float)(player.yBodyRot + 90.0f));
            } else {
                dir = Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot);
                side = Vec3.directionFromRotation((float)0.0f, (float)(this.yBodyRot + 90.0f));
            }
            dir = dir.scale((double)this.getBbWidth() * 0.5 + reach);
            double attackSize = 1.65;
            if (this.remainingLeftLegBones() > 0) {
                Vec3 rightPos = this.position().add(dir).add(side.scale(1.3));
                obbs.add(new OrientedBoundingBox(new AABB(-attackSize, -0.02, -attackSize, attackSize, 1.82, attackSize), this.getYRot(), 0.0f, rightPos));
            }
            if (this.remainingRightLegBones() > 0) {
                Vec3 leftPos = this.position().add(dir).add(side.scale(-1.3));
                obbs.add(new OrientedBoundingBox(new AABB(-attackSize, -0.02, -attackSize, attackSize, 1.82, attackSize), this.getYRot(), 0.0f, leftPos));
            }
        }
        HashSet targets = new HashSet();
        for (OrientedBoundingBox obb : obbs) {
            targets.addAll(this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.hitPred.test(entity) && obb.intersects(entity.getBoundingBox())));
            if (this.level().isClientSide) continue;
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        }
        targets.forEach(cons);
    }

    @Override
    public DynamicDamage.Builder damageSourceAttack() {
        DynamicDamage.Builder builder = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new String[]{TAIL_SLAP})) {
            builder.knock(DynamicDamage.KnockBackType.BACK, 1.0f);
        }
        return builder;
    }

    public AnimationHandler<Skelefang> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE);
            } else {
                this.getAnimationHandler().setAnimation(TAIL_SLAP);
            }
            this.commanded = true;
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        if (this.hasBones()) {
            return new Vec3(0.0, 2.71875, 0.4375).scale((double)this.getScale()).yRot(-this.getYRot() * ((float)Math.PI / 180));
        }
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick);
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    @Override
    public double deathRayOffset() {
        return (double)this.getBbHeight() * 0.3;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getDeathAnimation() {
        return DEATH;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getSleepAnimation() {
        return DEATH;
    }
}

