/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.ensemble;

import io.github.flemmli97.runecraftory.common.entities.EnsembleMonsters;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.Sano;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.Uno;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SanoAndUnoDuo
extends EnsembleMonsters {
    public SanoAndUnoDuo(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public List<Supplier<? extends EntityType<?>>> entities() {
        return List.of(RuneCraftoryEntities.SANO, RuneCraftoryEntities.UNO);
    }

    @Override
    public void spawnEntities(ServerLevel serverLevel) {
        BlockPos off = new BlockPos(5, 0, 4);
        Entity e = ((EntityType)RuneCraftoryEntities.SANO.get()).create(serverLevel, null, this.blockPosition().offset((Vec3i)off.rotate(this.rotation)), MobSpawnType.SPAWNER, false, false);
        UUID link = Mth.createInsecureUUID();
        if (e instanceof Sano) {
            Sano sano = (Sano)e;
            sano.setXPLevel(this.monsterLevel);
            sano.linkUsing(link);
            if (this.restrictRadius != -1) {
                sano.restrictTo(this.blockPosition(), this.restrictRadius);
            }
            sano.setXRot(0.0f);
            sano.setYRot(this.rotation.rotate(135, 360));
            sano.setYHeadRot(sano.getYRot());
            sano.setYBodyRot(sano.getYRot());
            serverLevel.addFreshEntityWithPassengers((Entity)sano);
        }
        off = new BlockPos(-5, 0, 4);
        e = ((EntityType)RuneCraftoryEntities.UNO.get()).create(serverLevel, null, this.blockPosition().offset((Vec3i)off.rotate(this.rotation)), MobSpawnType.SPAWNER, false, false);
        if (e instanceof Uno) {
            Uno uno = (Uno)e;
            uno.setXPLevel(this.monsterLevel);
            uno.linkUsing(link);
            if (this.restrictRadius != -1) {
                uno.restrictTo(this.blockPosition(), this.restrictRadius);
            }
            uno.setXRot(0.0f);
            uno.setYRot(this.rotation.rotate(225, 360));
            uno.setYHeadRot(uno.getYRot());
            uno.setYBodyRot(uno.getYRot());
            serverLevel.addFreshEntityWithPassengers((Entity)uno);
        }
    }

    @Override
    public boolean canSpawnerSpawn(ServerLevel level, BlockPos pos, int range) {
        return level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate((double)range), e -> e instanceof Sano || e instanceof Uno).isEmpty();
    }
}

