/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.calendar.DayOfWeek;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryActivities;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;

public class NPCSchedule {
    private final NPCEntity npc;
    private Schedule schedule;
    private List<Component> view;

    public NPCSchedule(NPCEntity npc, Schedule schedule) {
        this.npc = npc;
        this.schedule = schedule;
    }

    public NPCSchedule(NPCEntity npc, RandomSource random) {
        this(npc, new Schedule(random));
    }

    public static WrappedSchedule forBrain(Supplier<NPCSchedule> sup) {
        return new WrappedSchedule(sup);
    }

    public Activity getActivity(ServerLevel level) {
        if (!this.npc.getProfession().hasSchedule) {
            return Activity.IDLE;
        }
        int dayTime = WorldUtils.dayTime((Level)level);
        DayOfWeek day = Calendar.get((Level)level).date().day();
        if (dayTime < this.schedule.wakeUpTime) {
            return Activity.REST;
        }
        if (!this.npc.isBaby() && this.schedule.workDays.contains((Object)day) && this.npc.getProfession().hasWorkSchedule) {
            if (dayTime < this.schedule.workTime) {
                return (Activity)RuneCraftoryActivities.EARLY_IDLE.get();
            }
            if (dayTime < this.schedule.breakTime) {
                return Activity.WORK;
            }
            if (dayTime < this.schedule.workTimeAfter) {
                return Activity.MEET;
            }
            if (dayTime < this.schedule.doneWorkTime) {
                return Activity.WORK;
            }
        } else {
            if (dayTime < this.schedule.meetTime) {
                return Activity.IDLE;
            }
            if (dayTime < this.schedule.meetTimeAfter) {
                return Activity.MEET;
            }
        }
        if (dayTime < this.schedule.sleepTime) {
            return Activity.IDLE;
        }
        return Activity.REST;
    }

    public CompoundTag save() {
        return (CompoundTag)Schedule.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.schedule).getOrThrow();
    }

    public void load(CompoundTag tag) {
        this.schedule = Schedule.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(s -> RuneCraftory.LOGGER.error("Couldn't load schedule for {}. {}", (Object)this.npc, s)).orElse(new Schedule(this.npc.getRandom()));
        this.view = null;
    }

    public void with(Schedule schedule) {
        this.schedule = schedule;
        this.view = null;
    }

    public List<Component> viewSchedule() {
        if (!this.npc.getProfession().hasSchedule || !this.npc.getProfession().hasWorkSchedule) {
            return List.of();
        }
        if (this.view == null) {
            ArrayList<MutableComponent> newList = new ArrayList<MutableComponent>();
            boolean noBreaks = this.schedule.breakTime == this.schedule.workTimeAfter;
            newList.add(Component.translatable((String)"runecraftory.npc.schedule.work", (Object[])new Object[]{this.formatTime(this.schedule.workTime), noBreaks ? this.formatTime(this.schedule.doneWorkTime) : this.formatTime(this.schedule.breakTime)}));
            if (!noBreaks) {
                newList.add(Component.translatable((String)"runecraftory.npc.schedule.work.2", (Object[])new Object[]{this.formatTime(this.schedule.workTimeAfter), this.formatTime(this.schedule.doneWorkTime)}));
            }
            newList.add(Component.translatable((String)"runecraftory.npc.schedule.days.header"));
            ArrayList<DayOfWeek> weekDayCounts = new ArrayList<DayOfWeek>();
            for (DayOfWeek day2 : DayOfWeek.values()) {
                if (day2 == DayOfWeek.SATURDAY || day2 == DayOfWeek.SUNDAY || this.schedule.workDays.contains((Object)day2)) continue;
                weekDayCounts.add(day2);
            }
            if (this.schedule.workDays.size() == DayOfWeek.values().length) {
                newList.add(Component.translatable((String)"runecraftory.npc.schedule.days.all"));
            } else {
                switch (weekDayCounts.size()) {
                    case 0: {
                        newList.add(Component.translatable((String)"runecraftory.npc.schedule.days.0"));
                        break;
                    }
                    case 1: {
                        newList.add(Component.translatable((String)"runecraftory.npc.schedule.days.1", (Object[])new Object[]{Component.translatable((String)((DayOfWeek)((Object)weekDayCounts.get(0))).translationFull())}));
                        break;
                    }
                    case 2: {
                        newList.add(Component.translatable((String)"runecraftory.npc.schedule.days.2", (Object[])new Object[]{Component.translatable((String)((DayOfWeek)((Object)weekDayCounts.get(0))).translationFull()), Component.translatable((String)((DayOfWeek)((Object)weekDayCounts.get(1))).translationFull())}));
                        break;
                    }
                    default: {
                        newList.add(Component.translatable((String)"runecraftory.npc.schedule.days.with", (Object[])this.schedule.workDays.stream().filter(day -> day != DayOfWeek.SATURDAY && day != DayOfWeek.SUNDAY).map(e -> Component.translatable((String)e.translationFull())).toArray()));
                    }
                }
                if (this.schedule.workDays.contains((Object)DayOfWeek.SATURDAY)) {
                    if (this.schedule.workDays.contains((Object)DayOfWeek.SUNDAY)) {
                        newList.add(Component.translatable((String)"runecraftory.npc.schedule.days.weekend.2", (Object[])new Object[]{Component.translatable((String)DayOfWeek.SATURDAY.translationFull()), Component.translatable((String)DayOfWeek.SUNDAY.translationFull())}));
                    } else {
                        newList.add(Component.translatable((String)"runecraftory.npc.schedule.days.weekend.1", (Object[])new Object[]{Component.translatable((String)DayOfWeek.SATURDAY.translationFull())}));
                    }
                } else if (this.schedule.workDays.contains((Object)DayOfWeek.SUNDAY)) {
                    newList.add(Component.translatable((String)"runecraftory.npc.schedule.days.weekend.1", (Object[])new Object[]{Component.translatable((String)DayOfWeek.SUNDAY.translationFull())}));
                }
            }
            this.view = ImmutableList.copyOf(newList);
        }
        return this.view;
    }

    private String formatTime(int timeInTicks) {
        int hour = (timeInTicks + 6000) % 24000 / 1000;
        int min = (int)((double)(timeInTicks % 1000) * 0.06);
        String minS = (min < 10 ? "0" : "") + min;
        return String.format("%s:%s", hour, minS);
    }

    public static class Schedule {
        public static final Codec<Schedule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("wake_up_time").forGetter(d -> d.wakeUpTime), (App)ExtraCodecs.POSITIVE_INT.fieldOf("work_time").forGetter(d -> d.workTime), (App)ExtraCodecs.POSITIVE_INT.fieldOf("break_time").forGetter(d -> d.breakTime), (App)ExtraCodecs.POSITIVE_INT.fieldOf("work_time_after").forGetter(d -> d.workTimeAfter), (App)ExtraCodecs.POSITIVE_INT.fieldOf("done_work_time").forGetter(d -> d.doneWorkTime), (App)ExtraCodecs.POSITIVE_INT.fieldOf("meet_time").forGetter(d -> d.meetTime), (App)ExtraCodecs.POSITIVE_INT.fieldOf("meet_time_after").forGetter(d -> d.meetTimeAfter), (App)ExtraCodecs.POSITIVE_INT.fieldOf("sleep_time").forGetter(d -> d.sleepTime), (App)CodecUtils.stringEnumCodec(DayOfWeek.class, null).listOf().fieldOf("work_days").forGetter(d -> d.workDays.stream().toList())).apply((Applicative)inst, Schedule::new));
        public final int wakeUpTime;
        public final int workTime;
        public final int breakTime;
        public final int workTimeAfter;
        public final int doneWorkTime;
        public final int meetTime;
        public final int meetTimeAfter;
        public final int sleepTime;
        private final EnumSet<DayOfWeek> workDays;

        public Schedule(int wakeUpTime, int workTime, int breakTime, int workTimeAfter, int doneWorkTime, int sleepTime, int meetTimeOffday, int meetTimeAfterOffday, EnumSet<DayOfWeek> workDays) {
            this.wakeUpTime = wakeUpTime;
            this.workTime = Math.max(this.wakeUpTime + 500, workTime);
            this.breakTime = Math.max(this.workTime, breakTime);
            this.workTimeAfter = Math.max(this.breakTime, workTimeAfter);
            this.doneWorkTime = Math.max(this.workTimeAfter, doneWorkTime);
            this.meetTime = Math.max(this.wakeUpTime, meetTimeOffday);
            this.meetTimeAfter = Math.max(this.meetTime, meetTimeAfterOffday);
            this.sleepTime = Math.max(this.meetTimeAfter, Math.max(this.doneWorkTime, sleepTime));
            this.workDays = workDays;
        }

        private Schedule(int wakeUpTime, int workTime, int breakTime, int workTimeAfter, int doneWorkTime, int sleepTime, int meetTimeOffday, int meetTimeAfterOffday, List<DayOfWeek> workDays) {
            this(wakeUpTime, workTime, breakTime, workTimeAfter, doneWorkTime, sleepTime, meetTimeOffday, meetTimeAfterOffday, workDays.isEmpty() ? EnumSet.noneOf(DayOfWeek.class) : EnumSet.copyOf(workDays));
        }

        public Schedule(RandomSource random) {
            this(Schedule.randomizedTime(random, 6, 9), Schedule.randomizedTime(random, 8, 10), Schedule.randomizedTime(random, 11, 13), Schedule.randomizedTime(random, 12, 15), Schedule.randomizedTime(random, 16, 18), Schedule.randomizedTime(random, 20, 22), Schedule.randomizedTime(random, 9, 12), Schedule.randomizedTime(random, 13, 15), Schedule.randomizedWorkDays(random));
        }

        private static int randomizedTime(RandomSource random, int min, int max) {
            float hourAdd = (float)random.nextInt((max - min) * 2) * 0.5f;
            float hour = (float)min + hourAdd - 6.0f;
            return (int)(hour * 10.0f) * 100;
        }

        private static EnumSet<DayOfWeek> randomizedWorkDays(RandomSource random) {
            EnumSet<DayOfWeek> set = EnumSet.noneOf(DayOfWeek.class);
            for (DayOfWeek day : DayOfWeek.values()) {
                if (day == DayOfWeek.SATURDAY) {
                    if (!(random.nextFloat() < 0.4f)) continue;
                    set.add(day);
                    continue;
                }
                if (day == DayOfWeek.SUNDAY) {
                    if (!(random.nextFloat() < 0.15f)) continue;
                    set.add(day);
                    continue;
                }
                if (!(random.nextFloat() < 0.85f)) continue;
                set.add(day);
            }
            return set;
        }

        public Collection<DayOfWeek> getWorkDays() {
            return ImmutableSet.copyOf(this.workDays);
        }
    }

    public static class WrappedSchedule
    extends SmartBrainSchedule {
        private final Supplier<NPCSchedule> schedule;

        public WrappedSchedule(Supplier<NPCSchedule> schedule) {
            this.schedule = schedule;
        }

        public Activity tick(LivingEntity brainOwner) {
            return this.schedule.get().getActivity((ServerLevel)brainOwner.level());
        }
    }
}

