/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import io.github.flemmli97.runecraftory.client.NPCDialogueLanguageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;

public class PlaceHolderComponent {
    private static final List<String> PLACEHOLDERS = new ArrayList<String>();
    public static final String PLAYER = PlaceHolderComponent.addReplacement("%player%");
    public static final String NPC = PlaceHolderComponent.addReplacement("%npc%");
    public static final String FAVORITE = PlaceHolderComponent.addReplacement("%favorite%");
    public static final String LIKE = PlaceHolderComponent.addReplacement("%like%");
    public static final String DISLIKE = PlaceHolderComponent.addReplacement("%dislike%");
    public static final String HATE = PlaceHolderComponent.addReplacement("%hate%");

    private static String addReplacement(String pattern) {
        PLACEHOLDERS.add(pattern);
        return pattern;
    }

    public static Component parseDialogueComponent(Component component, Map<String, Component> replacements) {
        MutableComponent parse;
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            String translation = NPCDialogueLanguageManager.INSTANCE.getOrDefault(translatable.getKey());
            if (translation.equals(translatable.getKey())) {
                Language language = Language.getInstance();
                translation = language.getOrDefault(translatable.getKey());
            }
            ArrayList<Object> args = new ArrayList<Object>(List.of(translatable.getArgs()));
            for (String pattern : PLACEHOLDERS) {
                Component replacement = replacements.get(pattern);
                if (replacement == null) continue;
                translation = translation.replace(pattern, "%" + (args.size() + 1) + "$s");
                if (replacement instanceof MutableComponent) {
                    MutableComponent mut = (MutableComponent)replacement;
                    mut.withStyle(ChatFormatting.AQUA);
                }
                args.add(replacement);
            }
            parse = Component.translatable((String)translation, (Object[])args.toArray());
        } else {
            parse = component.plainCopy();
        }
        List<Component> children = component.getSiblings().stream().map(c -> PlaceHolderComponent.parseDialogueComponent(c, replacements)).toList();
        parse.getSiblings().addAll(children);
        return parse;
    }
}

