/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class NPCFeatureContainer
implements Iterable<NPCFeature> {
    private final Map<NPCFeatureType<?>, FeatureData> map = new HashMap();
    private final Map<NPCFeatureType<?>, FeatureData> view = Collections.unmodifiableMap(this.map);
    private Set<NPCFeature.NPCFeatureHolder<?>> conditionals = new HashSet();

    public <T extends NPCFeature> T getFeature(NPCFeatureType<T> type) {
        FeatureData data = this.map.get(type);
        return (T)(data != null ? data.getFeature() : null);
    }

    public <T extends NPCFeature> boolean contains(NPCFeatureType<T> type) {
        return this.map.containsKey(type);
    }

    public void buildFromLooks(NPCEntity npc, NPCLook look) {
        Level level = npc.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.map.clear();
        look.additionalFeatures().values().forEach(feat -> this.map.put(feat.getType(), new FeatureData((NPCFeature)feat.create(npc))));
        this.conditionals.clear();
        look.conditionalFeatures().forEach(feat -> {
            if (feat.predicate().matches(serverLevel, npc.position(), (Entity)npc)) {
                this.conditionals.add(feat.feature());
                this.withFeatureOverride(feat.feature().getType(), (NPCFeature)feat.feature().create(npc));
            }
        });
    }

    public boolean updateLooks(NPCEntity npc, NPCLook look) {
        Level level = npc.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (npc.tickCount % 20 != 0 || look.conditionalFeatures().isEmpty()) {
            return false;
        }
        HashSet changes = new HashSet();
        look.conditionalFeatures().forEach(feat -> {
            if (feat.predicate().matches(serverLevel, npc.position(), (Entity)npc)) {
                changes.add(feat.feature());
            }
        });
        if (!changes.equals(this.conditionals)) {
            this.conditionals.forEach(h -> this.withFeatureOverride(h.getType(), null));
            this.conditionals = changes;
            this.conditionals.forEach(feat -> this.withFeatureOverride(feat.getType(), (NPCFeature)feat.create(npc)));
            return true;
        }
        return false;
    }

    private void withFeatureOverride(NPCFeatureType<?> type, @Nullable NPCFeature override) {
        if (override == null) {
            FeatureData current = this.map.get(type);
            if (current != null) {
                if (current.base == null) {
                    this.map.remove(type);
                } else {
                    current.setOverride(null);
                }
            }
        } else {
            this.map.computeIfAbsent(type, k -> new FeatureData(null)).setOverride(override);
        }
    }

    public Tag save(HolderLookup.Provider provider) {
        return (Tag)FeatureData.CODEC.listOf().encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), List.copyOf(this.map.values())).getOrThrow();
    }

    public NPCFeatureContainer read(Tag tag, HolderLookup.Provider provider) {
        this.map.clear();
        ((List)FeatureData.CODEC.listOf().parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).promotePartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).getOrThrow()).forEach(feature -> this.map.put(feature.getFeature().type(), (FeatureData)feature));
        return this;
    }

    public void toBuffer(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.map.size());
        this.map.forEach((? super K type, ? super V feat) -> {
            buf.writeBoolean(feat.base != null);
            if (feat.base != null) {
                NPCFeature.STREAM_CODEC.encode((Object)buf, (Object)feat.base);
            }
            buf.writeBoolean(feat.override != null);
            if (feat.override != null) {
                NPCFeature.STREAM_CODEC.encode((Object)buf, (Object)feat.override);
            }
        });
    }

    public NPCFeatureContainer fromBuffer(RegistryFriendlyByteBuf buf) {
        this.map.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            FeatureData featureData = new FeatureData(buf.readBoolean() ? (NPCFeature)NPCFeature.STREAM_CODEC.decode((Object)buf) : null);
            if (buf.readBoolean()) {
                featureData.setOverride((NPCFeature)NPCFeature.STREAM_CODEC.decode((Object)buf));
            }
            this.map.put(featureData.getFeature().type(), featureData);
        }
        return this;
    }

    public void with(NPCFeatureContainer other) {
        this.map.clear();
        this.map.putAll(other.map);
    }

    @Override
    public Iterator<NPCFeature> iterator() {
        final Iterator<Map.Entry<NPCFeatureType<?>, FeatureData>> it = this.view.entrySet().iterator();
        return new Iterator<NPCFeature>(this){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public NPCFeature next() {
                return ((FeatureData)((Map.Entry)it.next()).getValue()).getFeature();
            }
        };
    }

    private static class FeatureData {
        private static final Codec<FeatureData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)NPCFeature.FEATURE_CODEC.optionalFieldOf("base").forGetter(d -> Optional.ofNullable(d.base)), (App)NPCFeature.FEATURE_CODEC.optionalFieldOf("override").forGetter(d -> Optional.ofNullable(d.override))).apply((Applicative)inst, (b, o) -> new FeatureData(b.orElse(null)).setOverride(o.orElse(null))));
        @Nullable
        private final NPCFeature base;
        @Nullable
        private NPCFeature override;

        private FeatureData(@Nullable NPCFeature base) {
            this.base = base;
        }

        public FeatureData setOverride(@Nullable NPCFeature override) {
            this.override = override;
            return this;
        }

        public NPCFeature getFeature() {
            if (this.override != null) {
                return this.override;
            }
            return this.base;
        }
    }
}

