/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.profession;

import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;

public class BathhouseAttendant
extends NPCProfession {
    public static final String BATH_ACTION = "runecraftory.npc.action.bath";
    public static final String BATH_ACTION_SUCCESS = "runecraftory.npc.action.bath.success";
    public static final String BATH_ACTION_FAIL = "runecraftory.npc.action.bath.fail";
    public static final String BATH_COST = "runecraftory.npc.shop.bath.cost";

    public BathhouseAttendant(NPCProfession.Builder builder) {
        super(builder);
    }

    @Override
    public void handleAction(NPCEntity npc, Player player, String action) {
        if (npc.canTrade() == ShopState.OPEN && action.equals(BATH_ACTION)) {
            int baths;
            int amount;
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            if (data.useMoney(amount = 300 * (baths = data.getDailyUpdater().getBathCounter() + 1) + Math.max(0, baths - 1) * 100)) {
                player.displayClientMessage((Component)Component.translatable((String)BATH_ACTION_SUCCESS, (Object[])new Object[]{player.getName()}), false);
                player.addEffect(new MobEffectInstance(RuneCraftoryEffects.BATH.asHolder(), 1700, 0, false, true, false));
                data.getDailyUpdater().increaseBathCounter();
            } else {
                player.displayClientMessage((Component)Component.translatable((String)BATH_ACTION_FAIL, (Object[])new Object[]{player.getName(), amount}), false);
            }
        }
    }

    @Override
    public Map<String, List<Component>> actions(NPCEntity entity, ServerPlayer player) {
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        int baths = data.getDailyUpdater().getBathCounter() + 1;
        int cost = 300 * baths + Math.max(0, baths - 1) * 100;
        return Map.of(BATH_ACTION, List.of(Component.translatable((String)BATH_COST, (Object[])new Object[]{cost})));
    }
}

