/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.profession;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Blacksmith
extends NPCProfession {
    public static final String BARN_ACTION = "runecraftory.npc.action.barn";
    public static final String BARN_ACTION_DESCRIPTION = "runecraftory.npc.action.barn.description";
    public static final String BARN_ACTION_SUCCESS = "runecraftory.npc.action.barn.success";
    public static final String BARN_ACTION_FAIL = "runecraftory.npc.action.barn.fail";
    public static final String BARN_COST = "runecraftory.npc.shop.barn.cost";
    public static final String BARN_COST_MAT = "runecraftory.npc.shop.barn.cost.mat";
    public static final String BARN_COST_FAIL = "runecraftory.npc.shop.barn.cost.fail";
    private static final IntUnaryOperator COST_FUNC = count -> {
        int clamped = Math.min(20, count + 1);
        return 1000 * clamped * clamped - Math.max(0, clamped - 1) * 2 * 1000;
    };
    private static final Function<Integer, Float> COST_FUNC_MAT_MULTIPLIER = count -> {
        int clamped = Math.min(10, count);
        return Float.valueOf(1.0f + (float)((int)Math.ceil((double)(clamped * clamped) * 0.5)) * 0.5f);
    };
    private static final Map<ItemPredicate, Integer> MATERIALS = ImmutableMap.of((Object)ItemPredicate.Builder.item().of(ItemTags.LOGS).build(), (Object)32, (Object)ItemPredicate.Builder.item().of(RunecraftoryTags.Items.COBBLESTONE).build(), (Object)64);

    public Blacksmith(NPCProfession.Builder builder) {
        super(builder);
    }

    @Override
    public void handleAction(NPCEntity npc, Player player, String action) {
        if (npc.canTrade() == ShopState.OPEN && action.equals(BARN_ACTION)) {
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            int amount = COST_FUNC.applyAsInt(data.getBoughtBarns());
            HashMap<ItemPredicate, List> stacks = new HashMap<ItemPredicate, List>();
            for (ItemStack stack : player.getInventory().items) {
                for (ItemPredicate itemPredicate : MATERIALS.keySet()) {
                    if (!itemPredicate.test(stack)) continue;
                    stacks.computeIfAbsent(itemPredicate, k -> new ArrayList()).add(stack);
                }
            }
            float multiplier = COST_FUNC_MAT_MULTIPLIER.apply(data.getBoughtBarns()).floatValue();
            boolean enough = MATERIALS.entrySet().stream().allMatch(p -> stacks.getOrDefault(p.getKey(), List.of()).stream().mapToInt(ItemStack::getCount).sum() >= (int)((float)((Integer)p.getValue()).intValue() * multiplier));
            if (enough && data.useMoney(amount)) {
                player.displayClientMessage((Component)Component.translatable((String)BARN_ACTION_SUCCESS, (Object[])new Object[]{player.getName()}), false);
                block2: for (Map.Entry entry : stacks.entrySet()) {
                    int needed = (int)((float)MATERIALS.get(entry.getKey()).intValue() * multiplier);
                    for (ItemStack stack : (List)entry.getValue()) {
                        if (needed > stack.getCount()) {
                            int count = stack.getCount();
                            stack.setCount(0);
                            needed -= count;
                            continue;
                        }
                        stack.shrink(needed);
                        continue block2;
                    }
                }
                if (!player.addItem(new ItemStack((ItemLike)RuneCraftoryItems.MONSTER_BARN.get()))) {
                    player.spawnAtLocation(new ItemStack((ItemLike)RuneCraftoryItems.MONSTER_BARN.get()));
                }
                data.onBuyBarn();
            } else {
                player.displayClientMessage((Component)Component.translatable((String)BARN_ACTION_FAIL, (Object[])new Object[]{player.getName(), amount}), false);
            }
        }
    }

    @Override
    public Map<String, List<Component>> actions(NPCEntity entity, ServerPlayer player) {
        return Map.of(BARN_ACTION, Blacksmith.getBarnActionComponent(player));
    }

    private static List<Component> getBarnActionComponent(ServerPlayer player) {
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        Object[] obj = new Object[MATERIALS.size()];
        int i = 0;
        for (Map.Entry<ItemPredicate, Integer> e : MATERIALS.entrySet()) {
            obj[i] = (int)((float)e.getValue().intValue() * COST_FUNC_MAT_MULTIPLIER.apply(data.getBoughtBarns()).floatValue());
            ++i;
        }
        return List.of(Component.translatable((String)BARN_COST, (Object[])new Object[]{COST_FUNC.applyAsInt(data.getBoughtBarns())}), Component.translatable((String)BARN_COST_MAT, (Object[])obj));
    }
}

