/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.blocks.entity.CraftingBlockEntity;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.inventory.WrappedContainer;
import io.github.flemmli97.runecraftory.common.inventory.container.CraftingOutputSlot;
import io.github.flemmli97.runecraftory.common.inventory.container.IngredientsCache;
import io.github.flemmli97.runecraftory.common.network.S2CCraftingRecipes;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.recipes.SpecialSextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMenuTypes;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ContainerCrafting
extends AbstractContainerMenu {
    private final PlayerBoundCraftingContainer craftingInv;
    private final CraftingType type;
    private final WrappedContainer output;
    private final CraftingBlockEntity blockEntity;
    private final DataSlot runePointCost;
    private final CraftingOutputSlot outputSlot;
    private final IngredientsCache cache;
    private List<RecipeHolder<? extends SextupleRecipe>> matchingRecipes;
    private ClientRecipeResult matchingRecipesClient = new ClientRecipeResult(0L, List.of());
    private RecipeHolder<? extends SextupleRecipe> selected;

    public ContainerCrafting(int windowId, Inventory inv, BlockPos pos) {
        this(windowId, inv, ContainerCrafting.getTile(inv.player.level(), pos));
    }

    public ContainerCrafting(int windowID, Inventory playerInv, CraftingBlockEntity blockEntity) {
        super((MenuType)RuneCraftoryMenuTypes.CRAFTING_CONTAINER.get(), windowID);
        this.output = new WrappedContainer((Container)new SimpleContainer(2));
        this.craftingInv = PlayerBoundCraftingContainer.create(this, blockEntity.getContainer(), playerInv.player);
        this.cache = new IngredientsCache(this.craftingInv);
        this.blockEntity = blockEntity;
        this.type = blockEntity.craftingType();
        this.outputSlot = new CraftingOutputSlot(this.output, this, this.craftingInv, 0, 116, 35);
        this.addSlot(this.outputSlot);
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.addSlot(new Slot((Container)playerInv, hotbar, 8 + hotbar * 18, 142));
        }
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlot(new Slot((Container)playerInv, row + column * 9 + 9, 8 + row * 18, 84 + column * 18));
            }
        }
        for (int i = 0; i < 3; ++i) {
            this.addSlot(new Slot((Container)this.craftingInv, i, 20 + i * 18, 26));
            this.addSlot(new Slot((Container)this.craftingInv, i + 3, 20 + i * 18, 44));
        }
        this.runePointCost = DataSlot.standalone();
        this.addDataSlot(this.runePointCost);
    }

    public static CraftingBlockEntity getTile(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CraftingBlockEntity) {
            return (CraftingBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Expected tile entity of type TileCrafting but got " + String.valueOf(blockEntity));
    }

    public void setSynchronizer(ContainerSynchronizer synchronizer) {
        this.updateCraftingOutput(true);
        super.setSynchronizer(synchronizer);
    }

    public static List<RecipeHolder<SextupleRecipe>> getRecipes(PlayerBoundCraftingContainer inv, CraftingType type) {
        Player player = inv.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.getServer().getRecipeManager().getRecipesFor(CraftingUtils.getType(type), (RecipeInput)inv, (Level)serverPlayer.serverLevel()).stream().filter(h -> SextupleRecipe.getCraftingOutput(inv, (RecipeHolder<? extends SextupleRecipe>)h) != null).sorted(Comparator.comparingInt(r -> ((SextupleRecipe)r.value()).getCraftingLevel())).toList();
        }
        return new ArrayList<RecipeHolder<SextupleRecipe>>();
    }

    public CraftingType craftingType() {
        return this.type;
    }

    public void updateCraftingOutput(boolean init) {
        if (this.craftingInv.getPlayer().level().isClientSide) {
            return;
        }
        if (this.cache.changedAndUpdate()) {
            this.matchingRecipes = new ArrayList<RecipeHolder<? extends SextupleRecipe>>();
            this.matchingRecipes.addAll(ContainerCrafting.getRecipes(this.craftingInv, this.type));
            if (this.matchingRecipes.isEmpty()) {
                RecipeHolder<SpecialSextupleRecipe> recipe;
                switch (this.type) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ACCESSORY_WORKBENCH: 
                    case FORGE: {
                        RecipeHolder<SpecialSextupleRecipe> recipeHolder = SpecialSextupleRecipe.SCRAP.get();
                        break;
                    }
                    case CHEMISTRY_SET: {
                        RecipeHolder<SpecialSextupleRecipe> recipeHolder = SpecialSextupleRecipe.OBJECT_X.get();
                        break;
                    }
                    case COOKING_TABLE: {
                        RecipeHolder<SpecialSextupleRecipe> recipeHolder = recipe = SpecialSextupleRecipe.FAILED_DISH.get();
                    }
                }
                if (((SpecialSextupleRecipe)recipe.value()).matches(this.craftingInv, this.craftingInv.getPlayer().level())) {
                    this.matchingRecipes.add(recipe);
                }
            }
            if (!init) {
                this.blockEntity.resetIndex();
            }
        }
        this.updateCraftingSlot(init, true);
    }

    private void updateCraftingSlot(boolean init, boolean recipeChanged) {
        ItemStack clientOutput;
        ItemStack trueOutput;
        if (this.matchingRecipes != null && !this.matchingRecipes.isEmpty()) {
            if (recipeChanged) {
                if (this.selected != null) {
                    int i;
                    for (i = this.matchingRecipes.size() - 1; i > 0 && !this.selected.equals(this.matchingRecipes.get(i)); --i) {
                    }
                    this.blockEntity.setIndex(i);
                } else if (!init || this.blockEntity.craftingIndex() >= this.matchingRecipes.size()) {
                    this.blockEntity.resetIndex();
                }
            }
            this.selected = this.matchingRecipes.get(this.blockEntity.craftingIndex());
            SextupleRecipe.RecipeOutput output = SextupleRecipe.getCraftingOutput(this.craftingInv, this.selected);
            if (output == null) {
                trueOutput = ItemStack.EMPTY;
                clientOutput = ItemStack.EMPTY;
                this.runePointCost.set(-1);
                this.selected = null;
            } else {
                this.runePointCost.set(CraftingUtils.craftingCost(this.type, (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.craftingInv.getPlayer()), (SextupleRecipe)this.selected.value(), output.bonusItems(), output.clientResult().getItem() != RuneCraftoryItems.UNKNOWN.get()));
                trueOutput = output.serverResult();
                clientOutput = output.clientResult();
            }
        } else {
            trueOutput = ItemStack.EMPTY;
            clientOutput = ItemStack.EMPTY;
            this.runePointCost.set(-1);
            this.selected = null;
        }
        this.output.setItem(0, trueOutput);
        this.output.setItem(1, clientOutput);
        Player player = this.craftingInv.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (recipeChanged) {
                this.sendCraftingRecipesToClient(player2, (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player2));
            }
            player2.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, clientOutput));
        }
    }

    public void sendCraftingRecipesToClient(ServerPlayer player, PlayerData data) {
        List<ItemStack> clientData = this.matchingRecipes.stream().map(recipe -> recipe.value() instanceof SpecialSextupleRecipe || data.getRecipeKeeper().isUnlocked((RecipeHolder<?>)recipe) ? ((SextupleRecipe)recipe.value()).getResultItem((HolderLookup.Provider)player.registryAccess()) : new ItemStack((ItemLike)RuneCraftoryItems.UNKNOWN.get())).toList();
        LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CCraftingRecipes(new ClientRecipeResult(player.level().getGameTime(), clientData), this.selected == null ? 0 : this.matchingRecipes.indexOf(this.selected)), player);
    }

    public void updateCurrentRecipeIndex(int id) {
        id = Mth.clamp((int)id, (int)0, (int)(this.matchingRecipes != null ? this.matchingRecipes.size() - 1 : 0));
        this.blockEntity.setIndex(id);
        this.updateCraftingSlot(false, false);
    }

    public RecipeHolder<? extends SextupleRecipe> getSelected() {
        return this.selected;
    }

    public int runepointCost() {
        return this.runePointCost.get();
    }

    public void broadcastChanges() {
        this.outputSlot.setSyncState(true);
        super.broadcastChanges();
        this.outputSlot.setSyncState(false);
    }

    public void sendAllDataToRemote() {
        this.outputSlot.setSyncState(true);
        super.sendAllDataToRemote();
        this.outputSlot.setSyncState(false);
    }

    public ItemStack quickMoveStack(Player player, int slotID) {
        if (!player.isAlive()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotID);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotID == 0) {
                itemstack1.onCraftedBy(player.level(), player, itemstack1.getCount());
                ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).onCrafted(player);
                if (!this.moveItemStackTo(itemstack1, 1, 37, false)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (slotID < 37 ? !this.moveItemStackTo(itemstack1, 37, this.slots.size(), false) : !this.moveItemStackTo(itemstack1, 1, 37, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            if (slotID == 0) {
                player.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void slotsChanged(Container container) {
        this.updateCraftingOutput(false);
        super.slotsChanged(container);
    }

    public ClientRecipeResult getMatchingRecipesClient() {
        return this.matchingRecipesClient;
    }

    public void setMatchingRecipesClient(ClientRecipeResult matchingRecipesClient) {
        this.matchingRecipesClient = matchingRecipesClient;
    }

    public record ClientRecipeResult(long lastChange, List<ItemStack> result) {
    }
}

