/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMenuTypes;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ShippingContainer
extends AbstractContainerMenu {
    private final Container container;

    public ShippingContainer(int i, Inventory inventory) {
        this(i, inventory, ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)inventory.player)).getShippingInv());
    }

    public ShippingContainer(int i, Inventory inventory, Container shippingBin) {
        super((MenuType)RuneCraftoryMenuTypes.SHIPPING_CONTAINER.get(), i);
        int column;
        int row;
        this.container = shippingBin;
        if (this.container == null) {
            throw new IllegalStateException("Couldn't get shipping container from player");
        }
        this.container.startOpen(inventory.player);
        int k = 36;
        for (row = 0; row < 6; ++row) {
            for (column = 0; column < 9; ++column) {
                final int slot = column + row * 9;
                this.addSlot(new Slot(this, this.container, slot, 8 + column * 18, 18 + row * 18){

                    public boolean mayPlace(ItemStack stack) {
                        return this.container.canPlaceItem(slot, stack);
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)inventory, column + row * 9 + 9, 8 + column * 18, 103 + row * 18 + k));
            }
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.addSlot(new Slot((Container)inventory, hotbar, 8 + hotbar * 18, 161 + k));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < 54 ? !this.moveItemStackTo(itemStack2, 54, this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, 54, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public Container getContainer() {
        return this.container;
    }
}

