/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.consumables;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemDualBladeBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemGloveBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemHammerBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemLongSwordBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpearBase;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.ForgingRecipe;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class ItemRecipeBread
extends Item {
    private final CraftingType type;

    public ItemRecipeBread(CraftingType type, Item.Properties props) {
        super(props);
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        block6: {
            block5: {
                ServerPlayer player;
                if (living instanceof ServerPlayer) {
                    player = (ServerPlayer)living;
                    int amount = Math.max(1, ItemComponentUtils.itemLevel(stack) / 3);
                    PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
                    HashMap grouped = new HashMap();
                    player.getServer().getRecipeManager().getAllRecipesFor(CraftingUtils.getType(this.type)).stream().filter(r -> ItemRecipeBread.canUnlockRecipe(level, (RecipeHolder<SextupleRecipe>)r, data, this.type.skill)).forEach(r -> grouped.computeIfAbsent(Pair.of((Object)((SextupleRecipe)r.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem(), (Object)((SextupleRecipe)r.value()).getCraftingLevel()), k -> new ArrayList()).add(r));
                    ArrayList unlocked = new ArrayList();
                    grouped.entrySet().stream().sorted(Comparator.comparingInt(p -> (Integer)((Pair)p.getKey()).getSecond())).limit(amount).forEach(r -> unlocked.addAll((Collection)r.getValue()));
                    data.getRecipeKeeper().unlockRecipes((Player)player, unlocked);
                    if (unlocked.isEmpty()) {
                        player.displayClientMessage((Component)Component.translatable((String)"runecraftory.misc.recipe.eat.fail"), false);
                    }
                }
                level.playSound(null, living.getX(), living.getY(), living.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                if (!(living instanceof Player)) break block5;
                player = (Player)living;
                if (player.getAbilities().instabuild) break block6;
            }
            stack.shrink(1);
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    private static boolean canUnlockRecipe(Level level, RecipeHolder<SextupleRecipe> r, PlayerData data, Skills skill) {
        SextupleRecipe recipe = (SextupleRecipe)r.value();
        if (recipe instanceof ForgingRecipe) {
            boolean weaponSkillCheck = true;
            Item res = recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem();
            if (res instanceof ItemLongSwordBase) {
                weaponSkillCheck = recipe.getCraftingLevel() - data.getSkillLevel(Skills.LONGSWORD).getLevel() <= 5;
            } else if (res instanceof ItemDualBladeBase) {
                weaponSkillCheck = recipe.getCraftingLevel() - data.getSkillLevel(Skills.DUAL).getLevel() <= 5;
            } else if (res instanceof SwordItem) {
                weaponSkillCheck = recipe.getCraftingLevel() - data.getSkillLevel(Skills.SHORTSWORD).getLevel() <= 5;
            } else if (res instanceof ItemSpearBase) {
                weaponSkillCheck = recipe.getCraftingLevel() - data.getSkillLevel(Skills.SPEAR).getLevel() <= 5;
            } else if (res instanceof ItemHammerBase || res instanceof AxeItem) {
                weaponSkillCheck = recipe.getCraftingLevel() - data.getSkillLevel(Skills.HAMMERAXE).getLevel() <= 5;
            } else if (res instanceof ItemGloveBase) {
                weaponSkillCheck = recipe.getCraftingLevel() - data.getSkillLevel(Skills.FIST).getLevel() <= 5;
            }
            return weaponSkillCheck && !data.getRecipeKeeper().isUnlocked(r) && recipe.getCraftingLevel() - data.getSkillLevel(skill).getLevel() <= 5;
        }
        return !data.getRecipeKeeper().isUnlocked(r) && recipe.getCraftingLevel() - data.getSkillLevel(skill).getLevel() <= 5;
    }
}

