/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.common.blocks.util.Growable;
import io.github.flemmli97.runecraftory.common.network.S2CTriggers;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class ItemFertilizer
extends Item {
    private static final List<BlockPos> AFFECTED = List.of(new BlockPos(1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(1, 0, -1));
    public static final IFertilizerOnUse FORMULAR_A = (stack, level, data, player) -> {
        data.applyGrowthFertilizer(level, 0.4f);
        return true;
    };
    public static final IFertilizerOnUse FORMULAR_B = (stack, level, data, player) -> {
        data.applyGrowthFertilizer(level, 1.0f);
        return true;
    };
    public static final IFertilizerOnUse FORMULAR_C = (stack, level, data, player) -> {
        data.applyGrowthFertilizer(level, 2.0f);
        return true;
    };
    public static final IFertilizerOnUse GREENIFIER = (stack, level, data, player) -> {
        data.modifyQuality(level, 0.2f);
        return true;
    };
    public static final IFertilizerOnUse GREENIFIER_PLUS = (stack, level, data, player) -> {
        data.modifyQuality(level, 0.5f);
        return true;
    };
    public static final IFertilizerOnUse GIANTIZER = (stack, level, data, player) -> {
        data.applySizeFertilizer(level, true);
        return true;
    };
    public static final IFertilizerOnUse MINIMIZER = (stack, level, data, player) -> {
        data.applySizeFertilizer(level, false);
        return true;
    };
    public static final IFertilizerOnUse WETTABLE = (stack, level, data, player) -> {
        data.modifyDefence(level, 48);
        return true;
    };
    private final IFertilizerOnUse use;

    public ItemFertilizer(IFertilizerOnUse use, Item.Properties properties) {
        super(properties);
        this.use = use;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel level2 = (ServerLevel)level;
        InteractionResult res = this.applyTo(level2, ctx.getClickedPos(), ctx, false);
        if (res == InteractionResult.CONSUME) {
            ItemFertilizer.getOtherForTargeted(ctx.getPlayer() == null ? Direction.NORTH : ctx.getPlayer().getDirection(), ctx.getClickedPos()).forEach(p -> this.applyTo(level2, (BlockPos)p, ctx, true));
            Player player = ctx.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!serverPlayer.isCreative()) {
                    ctx.getItemInHand().shrink(1);
                }
                ((PlayerTrigger)RuneCraftoryCriteria.FERTILIZE_FARM.get()).trigger(serverPlayer);
            }
        }
        return res;
    }

    private InteractionResult applyTo(ServerLevel level, BlockPos blockPos, UseOnContext ctx, boolean consecutive) {
        BlockState state = level.getBlockState(blockPos);
        if (FarmlandHandler.isFarmBlock(state)) {
            return FarmlandHandler.get(level.getServer()).getData(level, blockPos).map(d -> {
                if (this.use.useItemOnFarmland(ctx.getItemInHand(), level, (FarmlandData)d, ctx.getPlayer())) {
                    LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CTriggers(S2CTriggers.TriggerType.FERTILIZER, blockPos), level, new ChunkPos(blockPos));
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.PASS;
            }).orElse(InteractionResult.PASS);
        }
        if (consecutive || state.getBlock() instanceof BushBlock || state.getBlock() instanceof Growable) {
            BlockPos below = blockPos.below();
            return FarmlandHandler.get(level.getServer()).getData(level, below).map(d -> {
                if (this.use.useItemOnFarmland(ctx.getItemInHand(), level, (FarmlandData)d, ctx.getPlayer())) {
                    LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CTriggers(S2CTriggers.TriggerType.FERTILIZER, below), level, new ChunkPos(below));
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.PASS;
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    public static Stream<BlockPos> getOtherForTargeted(Direction direction, BlockPos ctxPos) {
        Rotation rot = switch (direction) {
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
        return AFFECTED.stream().map(p -> p.rotate(rot).offset((Vec3i)ctxPos));
    }

    public static interface IFertilizerOnUse {
        public boolean useItemOnFarmland(ItemStack var1, ServerLevel var2, FarmlandData var3, Player var4);
    }
}

