/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.entities.misc.CustomFishingHookEntity;
import io.github.flemmli97.runecraftory.common.items.ToolItemTier;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemToolFishingRod
extends FishingRodItem {
    public ItemToolFishingRod(Item.Properties props) {
        super(props);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.getUseDuration(entity) - remainingUseDuration;
            ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
            int chargeTime = ItemComponentUtils.getChargeTime(entity, tier);
            if (duration > 0 && duration / chargeTime <= tier.getTierLevel() && duration % chargeTime == 0) {
                EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0 && ((EntityData)RunecraftoryAttachments.ENTITY_DATA.get().get((Object)player)).fishingHook == null) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        this.throwRod(level, (LivingEntity)player, stack, 0);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0) {
            int useTime = (stack.getUseDuration(entity) - timeLeft - 1) / ItemComponentUtils.getChargeTime(entity, tier);
            int charge = Math.min(useTime, tier.getTierLevel());
            this.throwRod(level, entity, stack, charge);
            entity.swing(entity.getUsedItemHand());
        }
        super.releaseUsing(stack, level, entity, timeLeft);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    protected void throwRod(Level level, LivingEntity entity, ItemStack stack, int charge) {
        CustomFishingHookEntity hook = ((EntityData)RunecraftoryAttachments.ENTITY_DATA.get().get((Object)entity)).fishingHook;
        if (hook != null) {
            if (!level.isClientSide) {
                hook.retract(stack);
            }
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            entity.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                float speed = EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverLevel, (ItemStack)stack, (Entity)entity);
                int luck = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverLevel, (ItemStack)stack, (Entity)entity);
                ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
                hook = new CustomFishingHookEntity(level, entity, speed + (float)tier.getTierLevel(), luck, charge);
                hook.setElement(ItemComponentUtils.getElement(stack));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    hook.attackHandlingPlayer(() -> player.getCooldowns().getCooldownPercent(stack.getItem(), 0.0f) <= 0.0f, () -> player.getCooldowns().addCooldown(stack.getItem(), Mth.ceil((double)(20.0 * EntityUtils.attackSpeedModifier((LivingEntity)player)))));
                }
                level.addFreshEntity((Entity)hook);
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            entity.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
    }
}

