/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.ToolUseData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.ToolItemTier;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemToolHammer
extends PickaxeItem {
    public ItemToolHammer(Item.Properties props) {
        super(ItemTiers.TIER, props);
    }

    public static void onHammering(ServerPlayer player, boolean level) {
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        if (data.getWeaponHandler().getCurrentAction() == RuneCraftoryAttackActions.TOOL_HAMMER_USE.get()) {
            return;
        }
        LevelCalc.useRP(data, 5.0f, true, 0.0f, true, Skills.MINING);
        if (level) {
            LevelCalc.levelSkill(data, Skills.MINING, 10.0f);
        }
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.getUseDuration(entity) - remainingUseDuration;
            ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
            int chargeTime = ItemComponentUtils.getChargeTime(entity, tier);
            if (duration > 0 && duration / chargeTime <= tier.getTierLevel() && duration % chargeTime == 0) {
                EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ToolItemTier tier = (ToolItemTier)((Object)ctx.getItemInHand().getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() == 0) {
            return this.useOnSingleBlock(ctx, false);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            int useTime = data.getWeaponHandler().canExecuteAttack((AttackAction)RuneCraftoryAttackActions.TOOL_HAMMER_USE.get(), false) ? data.getWeaponHandler().get(DataKey.TOOL_DATA).charge() : (stack.getUseDuration(entity) - timeLeft - 1) / ItemComponentUtils.getChargeTime(entity, tier);
            int range = Math.min(useTime, tier.getTierLevel());
            BlockHitResult result = ItemToolHammer.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (range == 0) {
                this.useOnSingleBlock(new UseOnContext((Player)entity, entity.getUsedItemHand(), result), false);
            } else {
                data.getWeaponHandler().executeAttack((AttackAction)RuneCraftoryAttackActions.TOOL_HAMMER_USE.get(), stack);
                data.getWeaponHandler().store(DataKey.TOOL_DATA, new ToolUseData((HitResult)result, range));
            }
        }
        super.releaseUsing(stack, level, entity, timeLeft);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    private InteractionResult useOnSingleBlock(UseOnContext ctx, boolean canHammer) {
        Player player = ctx.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.PASS;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack stack = ctx.getItemInHand();
        HammerState state = this.hammer((ServerLevel)ctx.getLevel(), ctx.getClickedPos(), stack, (LivingEntity)ctx.getPlayer(), canHammer);
        if (state != HammerState.FAIL) {
            ItemToolHammer.onHammering(player2, state == HammerState.BREAK);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HammerState hammer(ServerLevel level, BlockPos pos, ItemStack stack, LivingEntity entity, boolean canHammer) {
        if (entity instanceof Player && !((Player)entity).mayUseItemAt(pos.relative(Direction.UP), Direction.UP, stack)) {
            return HammerState.FAIL;
        }
        BlockState state = level.getBlockState(pos);
        if (canHammer && state.is(RunecraftoryTags.Blocks.HAMMER_BREAKABLE)) {
            if (!(entity instanceof ServerPlayer)) return level.destroyBlock(pos, true, (Entity)entity, 3) ? HammerState.BREAK : HammerState.FAIL;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!serverPlayer.gameMode.destroyBlock(pos)) return HammerState.FAIL;
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
            serverPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket(pos, level.getBlockState(pos)));
            return HammerState.BREAK;
        }
        if (!state.is(RunecraftoryTags.Blocks.HAMMER_FLATTENABLE) || !level.getBlockState(pos.above()).isAir() || !level.setBlockAndUpdate(pos, Block.pushEntitiesUp((BlockState)state, (BlockState)Blocks.DIRT.defaultBlockState(), (LevelAccessor)level, (BlockPos)pos))) return HammerState.FAIL;
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        return HammerState.FLATTEN;
    }

    public static enum HammerState {
        FAIL,
        BREAK,
        FLATTEN;

    }
}

