/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.ToolItemTier;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemToolHoe
extends HoeItem {
    public ItemToolHoe(Item.Properties props) {
        super(ItemTiers.TIER, props);
    }

    public static void onHoeUse(ServerPlayer player) {
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        LevelCalc.useRP(data, 3.0f, true, 0.0f, true, Skills.FARMING, Skills.EARTH);
        LevelCalc.levelSkill(data, Skills.FARMING, 3.0f);
        LevelCalc.levelSkill(data, Skills.EARTH, 1.5f);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.getUseDuration(entity) - remainingUseDuration;
            int chargeTime = ItemComponentUtils.getChargeTime(entity, tier);
            if (duration > 0 && duration / chargeTime <= tier.getTierLevel() && duration % chargeTime == 0) {
                EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ToolItemTier tier = (ToolItemTier)((Object)ctx.getItemInHand().getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() == 0) {
            return this.useOnBlock(ctx);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int useTime = (stack.getUseDuration(entity) - timeLeft - 1) / ItemComponentUtils.getChargeTime(entity, tier);
            int range = Math.min(useTime, tier.getTierLevel());
            BlockHitResult result = ItemToolHoe.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (range == 0) {
                this.useOnBlock(new UseOnContext((Player)player, entity.getUsedItemHand(), result));
            } else {
                BlockPos pos = entity.blockPosition().below();
                if (result.getType() != HitResult.Type.MISS) {
                    pos = result.getBlockPos();
                }
                Function<BlockPos, BlockHitResult> hit = bh -> new BlockHitResult(Vec3.atCenterOf((Vec3i)bh), Direction.UP, bh, false);
                int amount = (int)BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, 0, -range), (BlockPos)pos.offset(range, 0, range)).filter(p -> this.hoeBlock(new UseOnContext((Player)player, entity.getUsedItemHand(), (BlockHitResult)hit.apply(p.immutable())))).count();
                if (amount > 0) {
                    PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
                    LevelCalc.useRP(data, 0.0f, true, (float)range * 17.5f, true, Skills.FARMING);
                    LevelCalc.levelSkill(data, Skills.FARMING, range * 15);
                    LevelCalc.levelSkill(data, Skills.EARTH, range * 2);
                }
            }
        }
        super.releaseUsing(stack, level, entity, timeLeft);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    private InteractionResult useOnBlock(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.PASS;
        }
        if (this.hoeBlock(ctx)) {
            ItemToolHoe.onHoeUse((ServerPlayer)ctx.getPlayer());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean hoeBlock(UseOnContext ctx) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        Pair tille = (Pair)TILLABLES.get(state.getBlock());
        if (tille != null && ((Predicate)tille.getFirst()).test(ctx)) {
            ((Consumer)tille.getSecond()).accept(ctx);
            if (ctx.getLevel().getBlockState(ctx.getClickedPos()).is(Blocks.FARMLAND)) {
                ctx.getLevel().setBlock(ctx.getClickedPos(), Blocks.FARMLAND.defaultBlockState(), 11);
            }
            ctx.getLevel().playSound(null, ctx.getClickedPos(), SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.1f);
            return true;
        }
        return false;
    }
}

