/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.ToolItemTier;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemToolWateringCan
extends Item {
    public ItemToolWateringCan(Item.Properties props) {
        super(props);
    }

    public void postUse(ServerPlayer player) {
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        LevelCalc.useRP(data, 2.0f, true, 0.0f, true, Skills.FARMING, Skills.WATER);
        LevelCalc.levelSkill(data, Skills.FARMING, 4.0f);
        LevelCalc.levelSkill(data, Skills.WATER, 1.0f);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.getUseDuration(entity) - remainingUseDuration;
            ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
            int chargeTime = ItemComponentUtils.getChargeTime(entity, tier);
            if (duration > 0 && duration / chargeTime <= tier.getTierLevel() && duration % chargeTime == 0) {
                EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ToolItemTier tier = (ToolItemTier)((Object)ctx.getItemInHand().getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() == 0) {
            return this.useOnBlock(ctx);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult ray = ItemToolWateringCan.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        ItemStack stack = player.getItemInHand(hand);
        BlockState state = level.getBlockState(ray.getBlockPos());
        if (state.getFluidState().getType() == Fluids.WATER) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.WATER.get(), (Object)((Integer)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.MAX_WATER.get(), (Object)0)));
            level.setBlock(ray.getBlockPos(), state.getFluidState().createLegacyBlock(), 3);
            player.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            return InteractionResultHolder.success((Object)stack);
        }
        ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        ToolItemTier tier = (ToolItemTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int useTime = (stack.getUseDuration(entity) - timeLeft - 1) / ItemComponentUtils.getChargeTime(entity, tier);
            int range = Math.min(useTime, tier.getTierLevel());
            BlockHitResult result = ItemToolWateringCan.getPlayerPOVHitResult((Level)level, (Player)((Player)entity), (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (range == 0) {
                this.useOnBlock(new UseOnContext((Player)entity, entity.getUsedItemHand(), result));
            } else {
                int amount;
                BlockPos pos = entity.blockPosition().below();
                if (result.getType() != HitResult.Type.MISS) {
                    pos = result.getBlockPos();
                }
                if ((amount = (int)BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -1, -range), (BlockPos)pos.offset(range, 0, range)).filter(p -> this.moisten((ServerLevel)level, p.immutable(), stack, entity)).count()) > 0) {
                    PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
                    LevelCalc.useRP(data, 0.0f, true, (float)range * 17.5f, true, Skills.FARMING);
                    LevelCalc.levelSkill(data, Skills.FARMING, range * 10);
                    LevelCalc.levelSkill(data, Skills.WATER, range * 3);
                }
            }
        }
        super.releaseUsing(stack, level, entity, timeLeft);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        int water = (Integer)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.WATER.get(), (Object)0);
        int max = (Integer)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.MAX_WATER.get(), (Object)0);
        return (int)((float)water / (float)max * 13.0f);
    }

    public int getBarColor(ItemStack stack) {
        int water = (Integer)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.WATER.get(), (Object)0);
        int max = (Integer)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.MAX_WATER.get(), (Object)0);
        float f = Math.max(0.0f, (float)water / (float)max);
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    private InteractionResult useOnBlock(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ctx.getItemInHand();
        Player player = ctx.getPlayer();
        BlockPos pos = ctx.getClickedPos();
        if (this.moisten((ServerLevel)ctx.getLevel(), pos, stack, (LivingEntity)player) || this.moisten((ServerLevel)ctx.getLevel(), pos.below(), stack, (LivingEntity)player)) {
            this.postUse((ServerPlayer)ctx.getPlayer());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean moisten(ServerLevel level, BlockPos pos, ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player && !((Player)entity).mayUseItemAt(pos.relative(Direction.UP), Direction.UP, stack)) {
            return false;
        }
        boolean creative = !(entity instanceof Player) || ((Player)entity).isCreative();
        BlockState state = level.getBlockState(pos);
        int water = (Integer)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.WATER.get(), (Object)0);
        if ((creative || water > 0) && state.is(RunecraftoryTags.Blocks.FARMLAND) && (Integer)state.getValue((Property)FarmBlock.MOISTURE) != 7) {
            FarmlandHandler.waterLand(level, pos, state);
            if (!creative) {
                stack.set((DataComponentType)RuneCraftoryDataComponentTypes.WATER.get(), (Object)(water - 1));
            }
            return true;
        }
        return false;
    }
}

