/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.tenshilib.common.item.DualWeapon;
import io.github.flemmli97.tenshilib.common.item.ExtendedWeapon;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ItemDualBladeBase
extends SwordItem
implements DualWeapon,
ExtendedWeapon {
    public ItemDualBladeBase(Item.Properties props) {
        super(ItemTiers.TIER, props);
    }

    public static void delayedRightClickAction(LivingEntity entity, ItemStack stack) {
        double width = CombatUtils.getWidth(entity, 0.0);
        double reach = CombatUtils.getRange(entity, 0.0);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, entity.getSoundSource(), 1.0f, 1.0f);
        if (ItemDualBladeBase.performRightClickAction(stack, entity, reach, width)) {
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, entity.getSoundSource(), 1.0f, 1.0f);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.DUAL, 3.0f);
            }
        }
    }

    public static boolean performRightClickAction(ItemStack stack, LivingEntity entity, double range, double width) {
        Collection<LivingEntity> list = CombatUtils.EntityAttack.aabbTargets(new AABB(-width * 0.5, 0.0, 0.0, width * 0.5, (double)entity.getBbHeight() + 0.2, range), false).apply(entity, null);
        if (!list.isEmpty()) {
            Supplier<DynamicDamage.Builder> base = () -> new DynamicDamage.Builder((Entity)entity).element(ItemComponentUtils.getElement(stack)).knock(DynamicDamage.KnockBackType.UP, 0.7f).hurtResistant(20);
            boolean success = false;
            double damagePhys = CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * 1.25;
            for (LivingEntity e : list) {
                if (!CombatUtils.damageWithFaintAndCrit((Entity)entity, (Entity)e, base.get(), damagePhys, stack)) continue;
                success = true;
            }
            return success;
        }
        return false;
    }

    public void executeAttack(Player player, ItemStack stack) {
        ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getWeaponHandler().executeAttack((AttackAction)RuneCraftoryAttackActions.DUAL_BLADES.get(), stack);
    }

    public boolean attackOnBlock(LivingEntity entity, ItemStack stack) {
        return true;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.getUseDuration(entity) - remainingUseDuration;
            if (duration == ItemComponentUtils.getChargeTime(entity)) {
                EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean canCharge;
        ItemStack itemstack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        boolean bl = canCharge = (data.getSkillLevel(Skills.DUAL).getLevel() >= 5 || player.isCreative()) && data.getWeaponHandler().canExecuteAttack((AttackAction)RuneCraftoryAttackActions.DUAL_USE.get());
        if (canCharge) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!level.isClientSide && stack.getUseDuration(entity) - timeLeft - 1 >= ItemComponentUtils.getChargeTime(entity)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getWeaponHandler().executeAttack((AttackAction)RuneCraftoryAttackActions.DUAL_USE.get(), stack);
                return;
            }
            if (ItemDualBladeBase.performRightClickAction(stack, entity, CombatUtils.getRange(entity, 0.0), CombatUtils.getWidth(entity, 0.0))) {
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, entity.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

