/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.tenshilib.common.item.DualWeapon;
import io.github.flemmli97.tenshilib.common.item.ExtendedWeapon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemGloveBase
extends Item
implements DualWeapon,
ExtendedWeapon {
    public ItemGloveBase(Item.Properties props) {
        super(props);
    }

    public void executeAttack(Player player, ItemStack stack) {
        ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getWeaponHandler().executeAttack((AttackAction)RuneCraftoryAttackActions.GLOVES.get(), stack);
    }

    public boolean attackOnBlock(LivingEntity entity, ItemStack stack) {
        return true;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.getUseDuration(entity) - remainingUseDuration;
            if (duration == ItemComponentUtils.getChargeTime(entity)) {
                EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean canCharge;
        ItemStack itemstack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        boolean bl = canCharge = (data.getSkillLevel(Skills.FIST).getLevel() >= 5 || player.isCreative()) && data.getWeaponHandler().canExecuteAttack((AttackAction)RuneCraftoryAttackActions.GLOVE_USE.get());
        if (canCharge) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (stack.getUseDuration(entity) - timeLeft - 1 >= ItemComponentUtils.getChargeTime(entity)) {
                ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)serverPlayer)).getWeaponHandler().executeAttack((AttackAction)RuneCraftoryAttackActions.GLOVE_USE.get(), stack);
            }
        }
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public ItemStack offHandStack(LivingEntity entity) {
        return ((EntityData)RunecraftoryAttachments.ENTITY_DATA.get().get((Object)entity)).getGloveOffHand(entity.getMainHandItem());
    }
}

