/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.lib;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.blocks.util.MineralBlockTier;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class RunecraftoryTags {
    private static TagKey<Item> tag(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)RuneCraftory.modRes(name));
    }

    public static TagKey<Item> tagCommon(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    private static TagKey<Block> block(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)RuneCraftory.modRes(name));
    }

    private static TagKey<Block> blockCommon(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    private static TagKey<Biome> biome(String name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)RuneCraftory.modRes(name));
    }

    private static TagKey<Biome> biomeCommon(String name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    private static TagKey<EntityType<?>> entity(String name) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)RuneCraftory.modRes(name));
    }

    private static TagKey<EntityType<?>> entityCommon(String name) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    private static TagKey<DamageType> damageCommon(String name) {
        return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static TagKey<Item> tamingTag(EntityType<?> type) {
        return Items.ENTITY_TAMING_TAGS.computeIfAbsent(type, r -> RunecraftoryTags.tag("taming/" + BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).getPath()));
    }

    public static class Items {
        public static final TagKey<Item> WOOD_ROD = RunecraftoryTags.tagCommon("rods/wooden");
        public static final TagKey<Item> SLIME = RunecraftoryTags.tagCommon("slime_balls");
        public static final TagKey<Item> SHEARS = RunecraftoryTags.tagCommon("tools/shear");
        public static final TagKey<Item> COBBLESTONE = RunecraftoryTags.tagCommon("cobblestones");
        public static final TagKey<Item> CHEST = RunecraftoryTags.tagCommon("chests");
        public static final TagKey<Item> IRON = RunecraftoryTags.tagCommon("ingots/iron");
        public static final TagKey<Item> GOLD = RunecraftoryTags.tagCommon("ingots/gold");
        public static final TagKey<Item> COPPER = RunecraftoryTags.tagCommon("ingots/copper");
        public static final TagKey<Item> RAW_MATERIALS_TIN = RunecraftoryTags.tagCommon("raw_materials/tin");
        public static final TagKey<Item> INGOTS_TIN = RunecraftoryTags.tagCommon("ingots/tin");
        public static final TagKey<Item> DUSTS_BRONZE = RunecraftoryTags.tagCommon("dusts/bronze");
        public static final TagKey<Item> INGOTS_BRONZE = RunecraftoryTags.tagCommon("ingots/bronze");
        public static final TagKey<Item> RAW_MATERIALS_SILVER = RunecraftoryTags.tagCommon("raw_materials/silver");
        public static final TagKey<Item> INGOTS_SILVER = RunecraftoryTags.tagCommon("ingots/silver");
        public static final TagKey<Item> RAW_MATERIALS_PLATINUM = RunecraftoryTags.tagCommon("raw_materials/platinum");
        public static final TagKey<Item> INGOTS_PLATINUM = RunecraftoryTags.tagCommon("ingots/platinum");
        public static final TagKey<Item> GEMS_EMERALD = RunecraftoryTags.tagCommon("gems/emerald");
        public static final TagKey<Item> GEMS_AMETHYST = RunecraftoryTags.tagCommon("gems/amethyst");
        public static final TagKey<Item> GEMS_AQUAMARINE = RunecraftoryTags.tagCommon("gems/aquamarine");
        public static final TagKey<Item> GEMS_RUBY = RunecraftoryTags.tagCommon("gems/ruby");
        public static final TagKey<Item> GEMS_SAPPHIRE = RunecraftoryTags.tagCommon("gems/sapphire");
        public static final TagKey<Item> EGGS = RunecraftoryTags.tagCommon("eggs");
        public static final TagKey<Item> MILKS = RunecraftoryTags.tagCommon("milks");
        public static final TagKey<Item> SEEDS = RunecraftoryTags.tagCommon("seeds");
        public static final TagKey<Item> FOODS = RunecraftoryTags.tagCommon("foods");
        public static final TagKey<Item> FOODS_FRUIT = RunecraftoryTags.tagCommon("foods/fruit");
        public static final TagKey<Item> FOODS_VEGGETABLE = RunecraftoryTags.tagCommon("foods/vegetable");
        public static final TagKey<Item> GRAPES = RunecraftoryTags.tagCommon("foods/fruit/grapes");
        public static final TagKey<Item> ORANGE = RunecraftoryTags.tagCommon("foods/fruit/orange");
        public static final TagKey<Item> FLOWERS = RunecraftoryTags.tagCommon("flowers");
        public static final TagKey<Item> CROPS = RunecraftoryTags.tagCommon("crops");
        public static final TagKey<Item> TURNIP = RunecraftoryTags.tagCommon("crops/turnip");
        public static final TagKey<Item> MONSTER_FEEDS = RunecraftoryTags.tag("monster_feeds");
        public static final TagKey<Item> ORICHALCUM = RunecraftoryTags.tagCommon("orichalcum");
        public static final TagKey<Item> DRAGONIC = RunecraftoryTags.tagCommon("dragonic");
        public static final TagKey<Item> GENERIC_TRASH = RunecraftoryTags.tag("generic_trash");
        public static final TagKey<Item> MINERALS = RunecraftoryTags.tag("mineral");
        public static final TagKey<Item> JEWELS = RunecraftoryTags.tag("jewels");
        public static final TagKey<Item> CRYSTALS = RunecraftoryTags.tag("crystals");
        public static final TagKey<Item> STICKS = RunecraftoryTags.tag("sticks");
        public static final TagKey<Item> LIQUIDS = RunecraftoryTags.tag("liquids");
        public static final TagKey<Item> FEATHERS = RunecraftoryTags.tagCommon("feathers");
        public static final TagKey<Item> SHELLS_BONES = RunecraftoryTags.tag("shells_bones");
        public static final TagKey<Item> STONES = RunecraftoryTags.tag("stones");
        public static final TagKey<Item> STRINGS = RunecraftoryTags.tagCommon("strings");
        public static final TagKey<Item> SHARDS = RunecraftoryTags.tag("shards");
        public static final TagKey<Item> FURS = RunecraftoryTags.tag("furs");
        public static final TagKey<Item> POWDERS = RunecraftoryTags.tag("powders");
        public static final TagKey<Item> CLOTHS = RunecraftoryTags.tag("cloths");
        public static final TagKey<Item> CLAWS_FANGS = RunecraftoryTags.tag("claws_fangs");
        public static final TagKey<Item> SCALES = RunecraftoryTags.tag("scales");
        public static final TagKey<Item> SPELLS = RunecraftoryTags.tag("spells");
        public static final TagKey<Item> MAGIC_SPELLS = RunecraftoryTags.tag("magic_spells");
        public static final TagKey<Item> RUNE_ABILITIES = RunecraftoryTags.tag("rune_abilities");
        public static final TagKey<Item> HIGH_TIER_TOOLS = RunecraftoryTags.tag("high_tier_tools");
        public static final TagKey<Item> UPGRADABLE_HELD = RunecraftoryTags.tag("upgradable_held");
        public static final TagKey<Item> TOOLS = RunecraftoryTags.tag("tools");
        public static final TagKey<Item> HOES = RunecraftoryTags.tag("tools/hoes");
        public static final TagKey<Item> WATERINGCANS = RunecraftoryTags.tag("tools/wateringcans");
        public static final TagKey<Item> SICKLES = RunecraftoryTags.tag("tools/sickles");
        public static final TagKey<Item> HAMMER_TOOLS = RunecraftoryTags.tag("tools/hammers");
        public static final TagKey<Item> AXE_TOOLS = RunecraftoryTags.tag("tools/axes");
        public static final TagKey<Item> FISHING_RODS = RunecraftoryTags.tag("tools/fishing_rods");
        public static final TagKey<Item> WEAPONS = RunecraftoryTags.tag("weapon");
        public static final TagKey<Item> SHORTSWORDS = RunecraftoryTags.tag("weapon/short_swords");
        public static final TagKey<Item> LONGSWORDS = RunecraftoryTags.tag("weapon/long_swords");
        public static final TagKey<Item> SPEARS = RunecraftoryTags.tag("weapon/spears");
        public static final TagKey<Item> AXES = RunecraftoryTags.tag("weapon/axes");
        public static final TagKey<Item> HAMMERS = RunecraftoryTags.tag("weapon/hammers");
        public static final TagKey<Item> HAMMER_AXES = RunecraftoryTags.tag("weapon/hammers_and_axes");
        public static final TagKey<Item> DUALBLADES = RunecraftoryTags.tag("weapon/dual_blades");
        public static final TagKey<Item> FISTS = RunecraftoryTags.tag("weapon/fists");
        public static final TagKey<Item> STAFFS = RunecraftoryTags.tag("weapon/staffs");
        public static final List<TagKey<Item>> WEAPONTAGS = List.of(SHORTSWORDS, LONGSWORDS, SPEARS, AXES, HAMMERS, DUALBLADES, FISTS, STAFFS);
        public static final TagKey<Item> EQUIPMENT = RunecraftoryTags.tag("equipment");
        public static final TagKey<Item> HELMET = RunecraftoryTags.tag("equipment/helmet");
        public static final TagKey<Item> CHESTPLATE = RunecraftoryTags.tag("equipment/chestplate");
        public static final TagKey<Item> ACCESSORIES = RunecraftoryTags.tag("equipment/accessories");
        public static final TagKey<Item> BOOTS = RunecraftoryTags.tag("equipment/boots");
        public static final TagKey<Item> SHIELDS = RunecraftoryTags.tag("equipment/shields");
        public static final TagKey<Item> FORGING_BLACKLIST = RunecraftoryTags.tag("forging_attribute_upgrade_blacklist");
        public static final TagKey<Item> ACCESSORY_BLACKLIST = RunecraftoryTags.tag("accessory_attribute_upgrade_blacklist");
        public static final TagKey<Item> CHEMISTRY_BLACKLIST = RunecraftoryTags.tag("chemistry_attribute_upgrade_blacklist");
        public static final TagKey<Item> COOKING_BLACKLIST = RunecraftoryTags.tag("cooking_attribute_upgrade_blacklist");
        public static final TagKey<Item> ONE_TIME_UPGRADE = RunecraftoryTags.tag("one_time_upgrade");
        public static final TagKey<Item> QUICKHARVEST_BYPASS = RunecraftoryTags.tag("quick_harvest_bypass");
        public static final TagKey<Item> FOOD_SIMPLE = RunecraftoryTags.tag("food/simple");
        public static final TagKey<Item> FOOD_FRIED = RunecraftoryTags.tag("food/fried");
        public static final TagKey<Item> POT = RunecraftoryTags.tag("food/pot");
        public static final TagKey<Item> STEAMED = RunecraftoryTags.tag("food/steamed");
        public static final TagKey<Item> KNIFE = RunecraftoryTags.tag("food/knife");
        public static final TagKey<Item> MIXED = RunecraftoryTags.tag("food/mixed");
        public static final TagKey<Item> OVEN = RunecraftoryTags.tag("food/oven");
        public static final TagKey<Item> OIL = RunecraftoryTags.tagCommon("foods/oil");
        public static final TagKey<Item> FLOUR = RunecraftoryTags.tagCommon("foods/flour");
        public static final TagKey<Item> CHEESE = RunecraftoryTags.tagCommon("foods/cheese");
        public static final TagKey<Item> MAYO = RunecraftoryTags.tagCommon("foods/mayo");
        public static final TagKey<Item> FOOD_EGG = RunecraftoryTags.tagCommon("foods/egg");
        public static final TagKey<Item> FOOD_MILK = RunecraftoryTags.tagCommon("foods/milk");
        public static final TagKey<Item> CHOCOLATE = RunecraftoryTags.tagCommon("foods/chocolate");
        public static final TagKey<Item> RICE = RunecraftoryTags.tagCommon("foods/rice");
        public static final TagKey<Item> BUTTER = RunecraftoryTags.tagCommon("foods/butter");
        public static final TagKey<Item> KETCHUP = RunecraftoryTags.tagCommon("foods/ketchup");
        public static final TagKey<Item> SUGAR = RunecraftoryTags.tagCommon("foods/sugar");
        public static final TagKey<Item> BREAD = RunecraftoryTags.tagCommon("foods/bread");
        public static final TagKey<Item> ONIGIRI = RunecraftoryTags.tagCommon("foods/onigiri");
        public static final TagKey<Item> PIE = RunecraftoryTags.tagCommon("foods/pie");
        public static final TagKey<Item> JUICE = RunecraftoryTags.tagCommon("foods/juice");
        public static final TagKey<Item> TOAST = RunecraftoryTags.tagCommon("foods/toast");
        public static final TagKey<Item> UDON = RunecraftoryTags.tagCommon("foods/udon");
        public static final TagKey<Item> JAM = RunecraftoryTags.tagCommon("foods/jam");
        private static final Map<EntityType<?>, TagKey<Item>> ENTITY_TAMING_TAGS = new HashMap();
    }

    public static class DamageTypes {
        public static final TagKey<DamageType> IS_MAGIC = RunecraftoryTags.damageCommon("is_magic");
        public static final TagKey<DamageType> BYPASS_MAGIC = RunecraftoryTags.damageCommon("bypass_magic");
    }

    public static class Attributes {
        public static final TagKey<Attribute> WEAPON_ONLY = TagKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)RuneCraftory.modRes("weapon_only"));
        public static final TagKey<Attribute> ARMOR_ONLY = TagKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)RuneCraftory.modRes("armor_only"));
        public static final TagKey<Attribute> NON_INHERITABLE = TagKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)RuneCraftory.modRes("non_inheritable"));
        public static final TagKey<Attribute> PERCENTAGE_DISPLAY = TagKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)RuneCraftory.modRes("percentage_display"));
        public static final TagKey<Attribute> DISPLAY_IGNORED = TagKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)RuneCraftory.modRes("display_ignored"));
        public static final TagKey<Attribute> RANDOMIZABLE_ATTRIBUTES = TagKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)RuneCraftory.modRes("randomizable_attributes"));
    }

    public static class Fluids {
        public static final TagKey<Fluid> HOT_SPRING_FLUID = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)RuneCraftory.modRes("hot_spring_water"));
    }

    public static class Biomes {
        public static final TagKey<Biome> IS_VOID = RunecraftoryTags.biomeCommon("is_void");
        public static final TagKey<Biome> IS_HOT = RunecraftoryTags.biomeCommon("is_hot");
        public static final TagKey<Biome> IS_HOT_OVERWORLD = RunecraftoryTags.biomeCommon("is_hot/overworld");
        public static final TagKey<Biome> IS_HOT_NETHER = RunecraftoryTags.biomeCommon("is_hot/nether");
        public static final TagKey<Biome> IS_HOT_END = RunecraftoryTags.biomeCommon("is_hot/end");
        public static final TagKey<Biome> IS_COLD = RunecraftoryTags.biomeCommon("is_cold");
        public static final TagKey<Biome> IS_COLD_OVERWORLD = RunecraftoryTags.biomeCommon("is_cold/overworld");
        public static final TagKey<Biome> IS_COLD_NETHER = RunecraftoryTags.biomeCommon("is_cold/nether");
        public static final TagKey<Biome> IS_COLD_END = RunecraftoryTags.biomeCommon("is_cold/end");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION = RunecraftoryTags.biomeCommon("is_sparse_vegetation");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION_OVERWORLD = RunecraftoryTags.biomeCommon("is_sparse_vegetation/overworld");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION_NETHER = RunecraftoryTags.biomeCommon("is_sparse_vegetation/nether");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION_END = RunecraftoryTags.biomeCommon("is_sparse_vegetation/end");
        public static final TagKey<Biome> IS_DENSE_VEGETATION = RunecraftoryTags.biomeCommon("is_dense_vegetation");
        public static final TagKey<Biome> IS_DENSE_VEGETATION_OVERWORLD = RunecraftoryTags.biomeCommon("is_dense_vegetation/overworld");
        public static final TagKey<Biome> IS_DENSE_VEGETATION_NETHER = RunecraftoryTags.biomeCommon("is_dense_vegetation/nether");
        public static final TagKey<Biome> IS_DENSE_VEGETATION_END = RunecraftoryTags.biomeCommon("is_dense_vegetation/end");
        public static final TagKey<Biome> IS_WET = RunecraftoryTags.biomeCommon("is_wet");
        public static final TagKey<Biome> IS_WET_OVERWORLD = RunecraftoryTags.biomeCommon("is_wet/overworld");
        public static final TagKey<Biome> IS_WET_NETHER = RunecraftoryTags.biomeCommon("is_wet/nether");
        public static final TagKey<Biome> IS_WET_END = RunecraftoryTags.biomeCommon("is_wet/end");
        public static final TagKey<Biome> IS_DRY = RunecraftoryTags.biomeCommon("is_dry");
        public static final TagKey<Biome> IS_DRY_OVERWORLD = RunecraftoryTags.biomeCommon("is_dry/overworld");
        public static final TagKey<Biome> IS_DRY_NETHER = RunecraftoryTags.biomeCommon("is_dry/nether");
        public static final TagKey<Biome> IS_DRY_END = RunecraftoryTags.biomeCommon("is_dry/end");
        public static final TagKey<Biome> IS_CONIFEROUS_TREE = RunecraftoryTags.biomeCommon("is_tree/coniferous");
        public static final TagKey<Biome> IS_SAVANNA_TREE = RunecraftoryTags.biomeCommon("is_tree/savanna");
        public static final TagKey<Biome> IS_JUNGLE_TREE = RunecraftoryTags.biomeCommon("is_tree/jungle");
        public static final TagKey<Biome> IS_DECIDUOUS_TREE = RunecraftoryTags.biomeCommon("is_tree/deciduous");
        public static final TagKey<Biome> IS_MOUNTAIN_PEAK = RunecraftoryTags.biomeCommon("is_mountain/peak");
        public static final TagKey<Biome> IS_MOUNTAIN_SLOPE = RunecraftoryTags.biomeCommon("is_mountain/slope");
        public static final TagKey<Biome> IS_PLAINS = RunecraftoryTags.biomeCommon("is_plains");
        public static final TagKey<Biome> IS_SNOWY_PLAINS = RunecraftoryTags.biomeCommon("is_snowy_plains");
        public static final TagKey<Biome> IS_BIRCH_FOREST = RunecraftoryTags.biomeCommon("is_birch_forest");
        public static final TagKey<Biome> IS_FLOWER_FOREST = RunecraftoryTags.biomeCommon("is_flower_forest");
        public static final TagKey<Biome> IS_OLD_GROWTH = RunecraftoryTags.biomeCommon("is_old_growth");
        public static final TagKey<Biome> IS_WINDSWEPT = RunecraftoryTags.biomeCommon("is_windswept");
        public static final TagKey<Biome> IS_SWAMP = RunecraftoryTags.biomeCommon("is_swamp");
        public static final TagKey<Biome> IS_DESERT = RunecraftoryTags.biomeCommon("is_desert");
        public static final TagKey<Biome> IS_STONY_SHORES = RunecraftoryTags.biomeCommon("is_stony_shores");
        public static final TagKey<Biome> IS_MUSHROOM = RunecraftoryTags.biomeCommon("is_mushroom");
        public static final TagKey<Biome> IS_SHALLOW_OCEAN = RunecraftoryTags.biomeCommon("is_shallow_ocean");
        public static final TagKey<Biome> IS_UNDERGROUND = RunecraftoryTags.biomeCommon("is_underground");
        public static final TagKey<Biome> IS_CAVE = RunecraftoryTags.biomeCommon("is_cave");
        public static final TagKey<Biome> IS_LUSH = RunecraftoryTags.biomeCommon("is_lush");
        public static final TagKey<Biome> IS_MAGICAL = RunecraftoryTags.biomeCommon("is_magical");
        public static final TagKey<Biome> IS_RARE = RunecraftoryTags.biomeCommon("is_rare");
        public static final TagKey<Biome> IS_PLATEAU = RunecraftoryTags.biomeCommon("is_plateau");
        public static final TagKey<Biome> IS_MODIFIED = RunecraftoryTags.biomeCommon("is_modified");
        public static final TagKey<Biome> IS_SPOOKY = RunecraftoryTags.biomeCommon("is_spooky");
        public static final TagKey<Biome> IS_WASTELAND = RunecraftoryTags.biomeCommon("is_wasteland");
        public static final TagKey<Biome> IS_DEAD = RunecraftoryTags.biomeCommon("is_dead");
        public static final TagKey<Biome> IS_FLORAL = RunecraftoryTags.biomeCommon("is_floral");
        public static final TagKey<Biome> IS_SANDY = RunecraftoryTags.biomeCommon("is_sandy");
        public static final TagKey<Biome> IS_SNOWY = RunecraftoryTags.biomeCommon("is_snowy");
        public static final TagKey<Biome> IS_ICY = RunecraftoryTags.biomeCommon("is_icy");
        public static final TagKey<Biome> IS_AQUATIC = RunecraftoryTags.biomeCommon("is_aquatic");
        public static final TagKey<Biome> IS_AQUATIC_ICY = RunecraftoryTags.biomeCommon("is_aquatic_icy");
        public static final TagKey<Biome> IS_NETHER_FOREST = RunecraftoryTags.biomeCommon("is_nether_forest");
        public static final TagKey<Biome> IS_OUTER_END_ISLAND = RunecraftoryTags.biomeCommon("is_outer_end_island");
        public static final TagKey<Biome> VANILLA_DIMENSIONS = RunecraftoryTags.biome("vanilla_dimensions");
        public static final TagKey<Biome> COMMON_GROUND_BLACKLIST = RunecraftoryTags.biome("common_ground_blacklist");
        public static final TagKey<Biome> GENERAL_HERBS = RunecraftoryTags.biome("general_herbs");
        public static final TagKey<Biome> HAS_HOT_SPRINGS = RunecraftoryTags.biome("has_hot_springs");
        public static final TagKey<Biome> FOREST_GROVE = RunecraftoryTags.biome("forest_grove");
        public static final TagKey<Biome> WATER_RUINS = RunecraftoryTags.biome("water_ruins");
        public static final TagKey<Biome> THEATER_RUINS = RunecraftoryTags.biome("theater_ruins");
        public static final TagKey<Biome> PLAINS_ARENA = RunecraftoryTags.biome("plains_arena");
        public static final TagKey<Biome> DESERT_ARENA = RunecraftoryTags.biome("desert_arena");
        public static final TagKey<Biome> NETHER_ARENA = RunecraftoryTags.biome("nether_arena");
        public static final TagKey<Biome> WIND_SHRINE = RunecraftoryTags.biome("wind_shrine");
        public static final TagKey<Biome> LEON_KARNAK = RunecraftoryTags.biome("leon_karnak");

        public static TagKey<Biome> getMineralGenTag(MineralBlockTier mineral, boolean whitelist) {
            return RunecraftoryTags.biome(mineral.getSerializedName() + (whitelist ? "_whitelist" : "_blacklist"));
        }

        public static TagKey<Biome> getBlockBasedGenerationTag(RegistryEntrySupplier<Block, ?> block, boolean whitelist) {
            String path = block.getID().getPath().replace("ore_", "");
            return RunecraftoryTags.biome(path + (whitelist ? "_whitelist" : "_blacklist"));
        }

        public record BiomeGenerationTags(List<TagKey<Biome>> whitelist, List<TagKey<Biome>> blacklist) {
        }
    }

    public static class EntityTypes {
        public static final TagKey<EntityType<?>> BOSSES = RunecraftoryTags.entityCommon("bosses");
        public static final TagKey<EntityType<?>> MONSTERS = RunecraftoryTags.entity("monsters");
        public static final TagKey<EntityType<?>> BOSS_MONSTERS = RunecraftoryTags.entity("boss_monsters");
        public static final TagKey<EntityType<?>> RAFFLESIA_SUMMONS = RunecraftoryTags.entity("rafflesia_summons");
        public static final TagKey<EntityType<?>> HELD_WEAPON_EXEMPT = RunecraftoryTags.entity("held_weapon_exempt");
        public static final TagKey<EntityType<?>> TAMED_MONSTER_IGNORE = RunecraftoryTags.entity("ignore_tamed_monsters");
        public static final TagKey<EntityType<?>> ELEMENTAL_DAMAGE_UNAFFECTED = RunecraftoryTags.entity("elemental_damage_unaffected");
        public static final TagKey<EntityType<?>> ELEMENTAL_SECONDARY_UNAFFECTED = RunecraftoryTags.entity("elemental_secondary_unaffected");
        public static final TagKey<EntityType<?>> MARIONETTA_TRAP_IGNORE = RunecraftoryTags.entity("marionetta_trap_ignore");
        public static final TagKey<EntityType<?>> HANDONETTA_GRAP_IGNORE = RunecraftoryTags.entity("handonetta_grab_ignore");
    }

    public static class Blocks {
        public static final TagKey<Block> FARMLAND = RunecraftoryTags.blockCommon("farmland");
        public static final TagKey<Block> STONE = RunecraftoryTags.blockCommon("stones");
        public static final TagKey<Block> ENDSTONES = RunecraftoryTags.blockCommon("end_stones");
        public static final TagKey<Block> ORES = RunecraftoryTags.blockCommon("ores");
        public static final TagKey<Block> MINERALS = RunecraftoryTags.block("minerals");
        public static final TagKey<Block> SICKLE_DESTROYABLE = RunecraftoryTags.block("sickle_destroyable");
        public static final TagKey<Block> SICKLE_EFFECTIVE = RunecraftoryTags.blockCommon("mineable/sickle");
        public static final TagKey<Block> HAMMER_FLATTENABLE = RunecraftoryTags.block("hammer_flattenable");
        public static final TagKey<Block> HAMMER_BREAKABLE = RunecraftoryTags.block("hammer_breakable");
        public static final TagKey<Block> HERBS = RunecraftoryTags.block("herbs");
        public static final TagKey<Block> CROP_BLOCKS = RunecraftoryTags.block("crops");
        public static final TagKey<Block> FLOWER_BLOCKS = RunecraftoryTags.block("flowers");
        public static final TagKey<Block> GIANT_CROP_BLOCKS = RunecraftoryTags.block("giant_crop");
        public static final TagKey<Block> MONSTER_CLEARABLE = RunecraftoryTags.block("monster_clearable");
        public static final TagKey<Block> BARN_GROUND = RunecraftoryTags.block("barn_ground");
        public static final TagKey<Block> MINERAL_GEN_PLACE = RunecraftoryTags.block("mineral_gen_place");
    }
}

