/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record BiomeLootCondition(TagKey<Biome> tag) implements LootItemCondition
{
    public static final MapCodec<BiomeLootCondition> CODEC = TagKey.codec((ResourceKey)Registries.BIOME).fieldOf("biome_tag").xmap(BiomeLootCondition::new, BiomeLootCondition::tag);

    public static LootItemCondition.Builder get(TagKey<Biome> tag) {
        return () -> new BiomeLootCondition(tag);
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)RuneCraftoryLootRegistries.BIOME.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.ORIGIN);
    }

    public boolean test(LootContext ctx) {
        return ctx.getLevel().getBiome(BlockPos.containing((Position)((Position)ctx.getParam(LootContextParams.ORIGIN)))).is(this.tag);
    }
}

