/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CropWeaponLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CropWeaponLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> CropWeaponLootFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CropWeaponLootFunction::new));

    private CropWeaponLootFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public LootItemFunctionType<CropWeaponLootFunction> getType() {
        return (LootItemFunctionType)RuneCraftoryLootRegistries.CROP_WEAPON_FUNCTION.get();
    }

    protected ItemStack run(ItemStack stack, LootContext ctx) {
        int i;
        if (!ItemComponentUtils.shouldHaveStats(stack)) {
            return stack;
        }
        boolean equipment = stack.is(RunecraftoryTags.Items.EQUIPMENT) && stack.getItem() instanceof ShieldItem;
        int level = 1;
        if (ctx.hasParam(LootCtxParameters.ITEM_LEVEL_CONTEXT)) {
            level = (Integer)ctx.getParam(LootCtxParameters.ITEM_LEVEL_CONTEXT);
        } else if (ctx.hasParam(LootContextParams.BLOCK_STATE) && ctx.hasParam(LootContextParams.ORIGIN)) {
            BlockPos blockPos = BlockPos.containing((Position)((Position)ctx.getParam(LootContextParams.ORIGIN)));
            level = FarmlandHandler.get(ctx.getLevel().getServer()).getData(ctx.getLevel(), blockPos).map(FarmlandData::getCropLevel).orElse(1);
        }
        List<Pair<ItemStack, ReloadableHolder<ItemStat>>> base = DataPackHandler.INSTANCE.itemStatManager().all(s -> !s.is(stack.getItem()) && equipment ? s.getItem() instanceof ShieldItem : s.is(RunecraftoryTags.Items.UPGRADABLE_HELD));
        if (!base.isEmpty()) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.LIGHT_ORE.get(), (Object)true);
            ItemComponentUtils.addUpgradeItem(stack, (ItemStack)base.get(ctx.getRandom().nextInt(base.size())).getFirst(), true, equipment ? CraftingType.ACCESSORY_WORKBENCH : CraftingType.FORGE);
        }
        List<Pair<ItemStack, ReloadableHolder<ItemStat>>> bonus = DataPackHandler.INSTANCE.itemStatManager().all(s -> !s.is(RunecraftoryTags.Items.WEAPONS) && !s.is(RunecraftoryTags.Items.EQUIPMENT));
        int bonusAmount = ctx.getRandom().nextInt(3) + 1;
        for (i = 0; i < bonusAmount; ++i) {
            ItemComponentUtils.addUpgradeItem(stack, (ItemStack)bonus.get(ctx.getRandom().nextInt(bonus.size())).getFirst(), true, equipment ? CraftingType.ACCESSORY_WORKBENCH : CraftingType.FORGE);
        }
        for (i = 1; i < level; ++i) {
            ItemComponentUtils.addUpgradeItem(stack, (ItemStack)bonus.get(ctx.getRandom().nextInt(bonus.size())).getFirst(), false, equipment ? CraftingType.ACCESSORY_WORKBENCH : CraftingType.FORGE);
        }
        return stack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new CropWeaponLootFunction(this.getConditions());
        }
    }
}

