/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record LuckBonusNumberProvider(NumberProvider base, float luck) implements NumberProvider
{
    public static final MapCodec<LuckBonusNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("base").forGetter(LuckBonusNumberProvider::base), (App)Codec.FLOAT.fieldOf("luck").forGetter(LuckBonusNumberProvider::luck)).apply((Applicative)instance, LuckBonusNumberProvider::new));

    public float getFloat(LootContext lootContext) {
        return this.base.getFloat(lootContext) + this.luck * lootContext.getLuck();
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)RuneCraftoryLootRegistries.LUCK_BOOSTED.get();
    }
}

