/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class C2SNPCInteraction
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<C2SNPCInteraction> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("c2s_npc_interaction"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2SNPCInteraction> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, C2SNPCInteraction>(){

        public C2SNPCInteraction decode(RegistryFriendlyByteBuf buf) {
            return new C2SNPCInteraction(buf.readInt(), (Action)buf.readEnum(Action.class), buf.readUtf());
        }

        public void encode(RegistryFriendlyByteBuf buf, C2SNPCInteraction pkt) {
            buf.writeInt(pkt.id);
            buf.writeEnum((Enum)pkt.type);
            buf.writeUtf(pkt.action);
        }
    };
    private final int id;
    private final Action type;
    private final String action;

    public C2SNPCInteraction(int entityID, Action type) {
        this(entityID, type, "");
    }

    public C2SNPCInteraction(int entityID, String action) {
        this(entityID, Action.ACTION, action);
    }

    public C2SNPCInteraction(int entityID, Action type, String action) {
        this.id = entityID;
        this.type = type;
        this.action = action == null ? "" : action;
    }

    public static void handle(C2SNPCInteraction pkt, ServerPlayer sender) {
        Entity entity = sender.level().getEntity(pkt.id);
        if (entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            switch (pkt.type.ordinal()) {
                case 0: {
                    npc.talkTo(sender);
                    break;
                }
                case 1: {
                    PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)sender);
                    if (!data.party.isPartyMember(entity) && data.party.isPartyFull()) {
                        sender.displayClientMessage((Component)Component.translatable((String)"runecraftory.monster.interact.party.full"), true);
                        return;
                    }
                    if (npc.getEntityToFollowUUID() != null) break;
                    npc.followEntity(sender);
                    break;
                }
                case 2: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.getUUID())) break;
                    npc.setBehaviour(NPCEntity.Behaviour.FOLLOW_DISTANCE);
                    break;
                }
                case 3: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.getUUID())) break;
                    npc.setBehaviour(NPCEntity.Behaviour.STAY);
                    break;
                }
                case 4: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.getUUID())) break;
                    npc.followEntity(null);
                    break;
                }
                case 5: {
                    npc.openShopForPlayer(sender);
                    break;
                }
                case 8: {
                    npc.respondToQuest(sender, ResourceLocation.parse((String)pkt.action));
                    break;
                }
                case 6: {
                    npc.closedDialogue(sender);
                    break;
                }
                case 7: {
                    npc.closedQuestDialogue(sender);
                    break;
                }
                case 9: {
                    if (npc.isBaby()) break;
                    npc.getProfession().handleAction(npc, (Player)sender, pkt.action);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Action {
        TALK("runecraftory.gui.npc.talk", null),
        FOLLOW("runecraftory.gui.npc.follow", NPCEntity.Behaviour.FOLLOW),
        FOLLOWDISTANCE("runecraftory.gui.npc.distance", NPCEntity.Behaviour.FOLLOW_DISTANCE),
        STAY("runecraftory.gui.npc.stay", NPCEntity.Behaviour.STAY),
        STOPFOLLOW("runecraftory.gui.npc.stopFollow", NPCEntity.Behaviour.WANDER),
        SHOP("runecraftory.gui.npc.shop", null),
        CLOSE("runecraftory.gui.npc.close", null),
        CLOSE_QUEST("runecraftory.gui.npc.close.quest", null),
        QUEST("runecraftory.gui.quest.button", null),
        ACTION("", null);

        public final String translation;
        @Nullable
        public final NPCEntity.Behaviour behaviour;

        private Action(String translation, NPCEntity.Behaviour behaviour) {
            this.translation = translation;
            this.behaviour = behaviour;
        }
    }
}

