/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.utils.BoundEntityListListener;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class S2CBoundEntityPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<S2CBoundEntityPacket> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("s2c_player_entity_list"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CBoundEntityPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, S2CBoundEntityPacket>(){

        public S2CBoundEntityPacket decode(RegistryFriendlyByteBuf buf) {
            return new S2CBoundEntityPacket(buf.readInt(), buf.readInt(), (Action)buf.readEnum(Action.class));
        }

        public void encode(RegistryFriendlyByteBuf buf, S2CBoundEntityPacket pkt) {
            buf.writeInt(pkt.entity);
            buf.writeInt(pkt.other);
            buf.writeEnum((Enum)pkt.action);
        }
    };
    private final int entity;
    private final int other;
    private final Action action;

    private S2CBoundEntityPacket(int entity, int other, Action action) {
        this.entity = entity;
        this.other = other;
        this.action = action;
    }

    public static <T extends Entity> void add(T entity, LivingEntity target) {
        LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CBoundEntityPacket(entity.getId(), target.getId(), Action.ADD), entity);
    }

    public static <T extends Entity> void remove(T entity, LivingEntity target) {
        LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CBoundEntityPacket(entity.getId(), target.getId(), Action.REMOVE), entity);
    }

    public static <T extends Entity> void clear(T entity) {
        LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CBoundEntityPacket(entity.getId(), -1, Action.CLEAR), entity);
    }

    public static void handle(S2CBoundEntityPacket pkt, Player player) {
        Entity entity = player.level().getEntity(pkt.entity);
        if (entity instanceof BoundEntityListListener) {
            BoundEntityListListener listener = (BoundEntityListListener)entity;
            if (pkt.action == Action.CLEAR) {
                listener.getList().clear();
                return;
            }
            Entity target = player.level().getEntity(pkt.other);
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                if (pkt.action == Action.ADD) {
                    listener.getList().add(living);
                } else {
                    listener.getList().remove(living);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static enum Action {
        ADD,
        REMOVE,
        CLEAR;

    }
}

