/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record S2CEntityDataSync(int entityID, DataType dataType, boolean flag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2CEntityDataSync> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("s2c_entity_data_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CEntityDataSync> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, S2CEntityDataSync>(){

        public S2CEntityDataSync decode(RegistryFriendlyByteBuf buf) {
            return new S2CEntityDataSync(buf.readInt(), (DataType)buf.readEnum(DataType.class), buf.readBoolean());
        }

        public void encode(RegistryFriendlyByteBuf buf, S2CEntityDataSync pkt) {
            buf.writeInt(pkt.entityID);
            buf.writeEnum((Enum)pkt.dataType);
            buf.writeBoolean(pkt.flag);
        }
    };

    public static void handle(S2CEntityDataSync pkt, Player player) {
        Entity e = player.level().getEntity(pkt.entityID);
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            EntityData data = (EntityData)RunecraftoryAttachments.ENTITY_DATA.get().get((Object)living);
            switch (pkt.dataType.ordinal()) {
                case 0: {
                    data.setInvis(pkt.flag ? 1 : 0);
                    break;
                }
                case 1: {
                    data.setThirdPersonView(pkt.flag);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum DataType {
        INVIS,
        ORTHOVIEW;

    }
}

