/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.world.data.family.SyncedFamilyData;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class S2COpenNPCGui
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<S2COpenNPCGui> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("s2c_npc_gui"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2COpenNPCGui> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, S2COpenNPCGui>(){

        public S2COpenNPCGui decode(RegistryFriendlyByteBuf buf) {
            return new S2COpenNPCGui(buf.readInt(), (ShopState)buf.readEnum(ShopState.class), buf.readInt(), buf.readMap(LinkedHashMap::new, (StreamDecoder)ByteBufCodecs.STRING_UTF8, buf1 -> buf1.readList(b -> (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf))), !buf.readBoolean() ? null : buf.readResourceLocation(), (SyncedFamilyData)SyncedFamilyData.STREAM_CODEC.decode((Object)buf));
        }

        public void encode(RegistryFriendlyByteBuf buf, S2COpenNPCGui pkt) {
            buf.writeInt(pkt.entityID);
            buf.writeEnum((Enum)pkt.isShopOpen);
            buf.writeInt(pkt.followState);
            buf.writeMap(pkt.actions, (StreamEncoder)ByteBufCodecs.STRING_UTF8, (buf1, components) -> buf1.writeCollection((Collection)components, (b, c) -> ComponentSerialization.STREAM_CODEC.encode((Object)buf, c)));
            buf.writeBoolean(pkt.quest != null);
            if (pkt.quest != null) {
                buf.writeResourceLocation(pkt.quest);
            }
            SyncedFamilyData.STREAM_CODEC.encode((Object)buf, (Object)pkt.family);
        }
    };
    private final int entityID;
    private final ShopState isShopOpen;
    private final int followState;
    private final Map<String, List<Component>> actions;
    private final ResourceLocation quest;
    private final SyncedFamilyData family;

    private S2COpenNPCGui(int id, ShopState isShopOpen, int followState, Map<String, List<Component>> actions, ResourceLocation quest, SyncedFamilyData family) {
        this.entityID = id;
        this.isShopOpen = isShopOpen;
        this.followState = followState;
        this.actions = actions;
        this.quest = quest;
        this.family = family;
    }

    public S2COpenNPCGui(NPCEntity entity, ServerPlayer player) {
        this.entityID = entity.getId();
        this.isShopOpen = entity.canTrade();
        this.actions = entity.getProfession().actions(entity, player);
        this.quest = QuestHandler.questForExists(player, entity);
        this.followState = entity.getEntityToFollowUUID() == null ? (((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).party.isPartyFull() ? 2 : 0) : (entity.getEntityToFollowUUID().equals(player.getUUID()) ? 1 : 2);
        this.family = entity.getFamily().forSyncing(entity, player);
    }

    public static void handle(S2COpenNPCGui pkt) {
        ClientHandlers.openNPCChat(pkt.entityID, pkt.isShopOpen, pkt.family, pkt.followState, pkt.actions, pkt.quest);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

