/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class S2CPlayerAnimation
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<S2CPlayerAnimation> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"runecraftory", (String)"s2c_player_animation"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CPlayerAnimation> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, S2CPlayerAnimation>(){

        public S2CPlayerAnimation decode(RegistryFriendlyByteBuf buf) {
            return new S2CPlayerAnimation(buf.readInt(), buf.readBoolean() ? (AnimationState.SyncableState)AnimationState.SyncableState.STREAM_CODEC.decode((Object)buf) : null);
        }

        public void encode(RegistryFriendlyByteBuf buf, S2CPlayerAnimation pkt) {
            buf.writeInt(pkt.entityID);
            buf.writeBoolean(pkt.state != null);
            if (pkt.state != null) {
                AnimationState.SyncableState.STREAM_CODEC.encode((Object)buf, (Object)pkt.state);
            }
        }
    };
    private final int entityID;
    private final AnimationState.SyncableState state;

    private S2CPlayerAnimation(int entityID, @Nullable AnimationState.SyncableState state) {
        this.entityID = entityID;
        this.state = state;
    }

    private S2CPlayerAnimation(Player player, @Nullable AnimationState.SyncableState state) {
        this(player.getId(), state);
        AnimationHandler<Player> handler = ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getWeaponHandler().getAnimationHandler();
        if (state != null && handler.getAnimations().get(state.id()) == null) {
            RuneCraftory.LOGGER.error("This animation is not registered for {}. Registered animations are {} but set animation is {}", (Object)player, (Object)handler.getAnimations().all(), (Object)state.id());
        }
    }

    public static S2CPlayerAnimation create(Player player) {
        AnimationState state = ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getWeaponHandler().getAnimationHandler().getAnimation();
        return new S2CPlayerAnimation(player, state != null ? state.forSync() : null);
    }

    public static S2CPlayerAnimation create(Player player, double offset) {
        AnimationState state = ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getWeaponHandler().getAnimationHandler().getAnimation();
        return new S2CPlayerAnimation(player, state != null ? state.forSync().withOffset(offset) : null);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(S2CPlayerAnimation pkt, Player player) {
        Entity entity = player.level().getEntity(pkt.entityID);
        if (entity instanceof Player) {
            Player target = (Player)entity;
            AnimationHandler<Player> handler = ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)target)).getWeaponHandler().getAnimationHandler();
            if (pkt.state == null) {
                handler.setAnimationDef(null);
            } else {
                handler.setAnimation(handler.getAnimations().get(pkt.state.id()), pkt.state.startTransition(), pkt.state.endTransition(), pkt.state.offset(), pkt.state.speed());
            }
        }
    }
}

